/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.reach.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.core.LanguageElement;

public final class Address {
    private final List<Description> desc = new ArrayList<Description>();
    @XmlAttribute
    private final URI uri;

    private Address() {
        this.uri = null;
    }

    public Address(URI uri, Description ... descriptions) {
        this.uri = Objects.requireNonNull(uri);
        this.desc.addAll(Arrays.asList(descriptions));
    }

    public final URI getUri() {
        return this.uri;
    }

    public final List<Description> getDescriptions() {
        return Collections.unmodifiableList(this.desc);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        return Objects.equals(this.desc, other.desc) && Objects.equals(this.uri, other.uri);
    }

    public final int hashCode() {
        return Objects.hash(this.desc, this.uri);
    }

    public final String toString() {
        return this.uri != null ? this.uri.toString() : super.toString();
    }

    public static final class Description
    implements LanguageElement {
        @XmlValue
        private final String value;
        @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
        private final Locale lang;

        private Description() {
            this(null, null);
        }

        public Description(String value, Locale language) {
            this.value = value;
            this.lang = language;
        }

        public final String getValue() {
            return this.value;
        }

        public final Locale getLanguage() {
            return this.lang;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description other = (Description)o;
            return Objects.equals(this.value, other.value) && Objects.equals(this.lang, other.lang);
        }

        public final int hashCode() {
            return Objects.hash(this.value, this.lang);
        }

        public final String toString() {
            return this.value;
        }
    }
}

