/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.seclabel.model.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.seclabel.model.SecurityLabel;

@XmlRootElement(name="catalog")
public final class Catalog {
    @XmlAttribute(name="to")
    private final Jid to;
    @XmlAttribute(name="from")
    private final Jid from;
    @XmlAttribute(name="name")
    private final String name;
    @XmlAttribute(name="desc")
    private final String description;
    @XmlAttribute(name="id")
    private final String id;
    @XmlAttribute(name="size")
    private final Integer size;
    @XmlAttribute(name="restrict")
    private final Boolean restrict;
    @XmlElement(name="item")
    private final List<Item> items = new ArrayList<Item>();

    public Catalog() {
        this(null, null, null, null, null, null, null, null);
    }

    public Catalog(Jid to, Jid from, String name, String description, String id, Integer size, Boolean restrict, Collection<Item> items) {
        this.to = to;
        this.from = from;
        this.name = name;
        this.description = description;
        this.id = id;
        this.size = size;
        this.restrict = restrict;
        if (items != null) {
            this.items.addAll(items);
        }
    }

    public final Jid getTo() {
        return this.to;
    }

    public final Jid getFrom() {
        return this.from;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getId() {
        return this.id;
    }

    public final boolean isRestrictive() {
        return this.restrict != null && this.restrict != false;
    }

    public final Integer getSize() {
        return this.size;
    }

    public final List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public static final class Item {
        @XmlAttribute(name="selector")
        private final String selector;
        @XmlAttribute(name="default")
        private final Boolean aDefault;
        @XmlElementRef
        private final SecurityLabel securityLabel;

        public Item() {
            this.selector = null;
            this.aDefault = null;
            this.securityLabel = null;
        }

        public Item(String selector, SecurityLabel securityLabel, Boolean isDefault) {
            this.selector = selector;
            this.aDefault = isDefault;
            this.securityLabel = securityLabel;
        }

        public final SecurityLabel getSecurityLabel() {
            return this.securityLabel;
        }

        public final String getSelector() {
            return this.selector;
        }

        public final boolean isDefault() {
            return this.aDefault != null && this.aDefault != false;
        }
    }
}

