/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.dialback.model;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.server.ServerStanzaError;
import rocks.xmpp.extensions.dialback.model.feature.DialbackFeature;

@XmlTransient
@XmlSeeAlso(value={Result.class, Verify.class, DialbackFeature.class})
public abstract class Dialback {
    public static final String NAMESPACE = "jabber:server:dialback";
    @XmlAttribute
    private final Jid from;
    @XmlAttribute
    private final Jid to;
    @XmlAttribute
    private final Type type;
    @XmlMixed
    @XmlElementRef(type=ServerStanzaError.class)
    private final List<Object> mixedContent = new ArrayList<Object>();

    private Dialback() {
        this.from = null;
        this.to = null;
        this.type = null;
    }

    private Dialback(Jid from, Jid to, String key, Boolean valid) {
        this.from = Objects.requireNonNull(from);
        this.to = Objects.requireNonNull(to);
        this.type = valid != null ? (valid.booleanValue() ? Type.VALID : Type.INVALID) : null;
        this.mixedContent.add(key);
    }

    private Dialback(Jid from, Jid to, StanzaError stanzaError) {
        this.from = from;
        this.to = to;
        this.type = Type.ERROR;
        this.mixedContent.add(ServerStanzaError.from((StanzaError)stanzaError));
    }

    public static String generateKey(String secret, String receivingServer, String originatingServer, String streamId) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] sha = digest.digest(secret.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec key = new SecretKeySpec(DatatypeConverter.printHexBinary((byte[])sha).toLowerCase(Locale.ENGLISH).getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            mac.init(key);
            mac.update((receivingServer + " " + originatingServer + " " + streamId).getBytes(StandardCharsets.UTF_8));
            return DatatypeConverter.printHexBinary((byte[])mac.doFinal()).toLowerCase(Locale.ENGLISH);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final Jid getFrom() {
        return this.from;
    }

    public final Jid getTo() {
        return this.to;
    }

    public final boolean isValid() {
        return this.type == null || this.type == Type.VALID;
    }

    public final String getKey() {
        return this.mixedContent.stream().filter(o -> o instanceof String).map(o -> (String)o).findAny().orElse(null);
    }

    public final StanzaError getError() {
        return this.mixedContent.stream().filter(o -> o instanceof StanzaError).map(o -> (StanzaError)o).findAny().orElse(null);
    }

    @XmlRootElement(name="verify")
    public static final class Verify
    extends Dialback {
        @XmlAttribute
        private final String id;

        private Verify() {
            this.id = null;
        }

        public Verify(Jid from, Jid to, String id, String key) {
            super(from, to, key, null);
            this.id = id;
        }

        public Verify(Jid from, Jid to, String id, boolean valid) {
            super(from, to, null, valid);
            this.id = id;
        }

        public Verify(Jid from, Jid to, String id, StanzaError error) {
            super(from, to, error);
            this.id = id;
        }

        public final String getId() {
            return this.id;
        }
    }

    @XmlRootElement(name="result")
    public static final class Result
    extends Dialback {
        private Result() {
        }

        public Result(Jid from, Jid to, String key) {
            super(from, to, Objects.requireNonNull(key), null);
        }

        public Result(Jid from, Jid to, boolean valid) {
            super(from, to, null, valid);
        }

        public Result(Jid from, Jid to, StanzaError error) {
            super(from, to, error);
        }
    }

    private static enum Type {
        ERROR,
        INVALID,
        VALID;

    }
}

