/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.extensions.privacy.model.PrivacyList;

@XmlRootElement(name="query")
public final class Privacy {
    public static final String NAMESPACE = "jabber:iq:privacy";
    private final List<PrivacyList> list = new ArrayList<PrivacyList>();
    @XmlJavaTypeAdapter(value=ActiveNameAdapter.class)
    @XmlElement(name="active")
    private final String activeName;
    @XmlJavaTypeAdapter(value=DefaultNameAdapter.class)
    @XmlElement(name="default")
    private final String defaultName;

    public Privacy() {
        this((String)null, (String)null, (Collection<PrivacyList>)null);
    }

    public Privacy(PrivacyList ... privacyLists) {
        this(null, null, Arrays.asList(privacyLists));
    }

    public Privacy(String activeName, String defaultName, Collection<PrivacyList> privacyLists) {
        this.activeName = activeName;
        this.defaultName = defaultName;
        if (privacyLists != null) {
            this.list.addAll(privacyLists);
        }
    }

    public static Privacy withActive(String active) {
        return new Privacy(Objects.requireNonNull(active), null, null);
    }

    public static Privacy withDefault(String defaultName) {
        return new Privacy(null, Objects.requireNonNull(defaultName), null);
    }

    public final String getActiveName() {
        return this.activeName;
    }

    public final String getDefaultName() {
        return this.defaultName;
    }

    public final List<PrivacyList> getPrivacyLists() {
        return Collections.unmodifiableList(this.list);
    }

    public final String toString() {
        return "Privacy lists: " + this.list;
    }

    private static final class DefaultNameAdapter
    extends XmlAdapter<Default, String> {
        private DefaultNameAdapter() {
        }

        public final String unmarshal(Default v) {
            if (v != null) {
                return v.name;
            }
            return null;
        }

        public final Default marshal(String v) {
            if (v != null) {
                Default def = new Default();
                def.name = v.isEmpty() ? null : v;
                return def;
            }
            return null;
        }
    }

    private static final class ActiveNameAdapter
    extends XmlAdapter<Active, String> {
        private ActiveNameAdapter() {
        }

        public final String unmarshal(Active v) {
            if (v != null) {
                return v.name;
            }
            return null;
        }

        public final Active marshal(String v) {
            if (v != null) {
                Active active = new Active();
                active.name = v.isEmpty() ? null : v;
                return active;
            }
            return null;
        }
    }

    private static final class Default {
        @XmlAttribute
        private String name;

        private Default() {
        }
    }

    private static final class Active {
        @XmlAttribute
        private String name;

        private Active() {
        }
    }
}

