/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaErrorException;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.rpc.RpcException;
import rocks.xmpp.extensions.rpc.RpcHandler;
import rocks.xmpp.extensions.rpc.RpcManager;
import rocks.xmpp.extensions.rpc.model.Rpc;
import rocks.xmpp.extensions.rpc.model.Value;

public abstract class AbstractRpcManager
extends AbstractIQHandler
implements RpcManager,
ExtensionProtocol,
DiscoverableInfo {
    private static final Set<String> FEATURES = Collections.singleton("jabber:iq:rpc");
    private static final System.Logger logger = System.getLogger(AbstractRpcManager.class.getName());
    private RpcHandler rpcHandler;

    protected AbstractRpcManager() {
        super(Rpc.class, new IQ.Type[]{IQ.Type.SET});
    }

    @Override
    public synchronized void setRpcHandler(RpcHandler rpcHandler) {
        this.rpcHandler = rpcHandler;
    }

    public final String getNamespace() {
        return "jabber:iq:rpc";
    }

    public final synchronized boolean isEnabled() {
        return this.rpcHandler != null;
    }

    public final Set<Identity> getIdentities() {
        return Collections.singleton(Identity.automationRpc());
    }

    public final Set<String> getFeatures() {
        return FEATURES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IQ processRequest(IQ iq) {
        RpcHandler rpcHandler1;
        Rpc rpc = (Rpc)iq.getExtension(Rpc.class);
        AbstractRpcManager abstractRpcManager = this;
        synchronized (abstractRpcManager) {
            rpcHandler1 = this.rpcHandler;
        }
        if (rpcHandler1 != null) {
            Rpc.MethodCall methodCall = rpc.getMethodCall();
            ArrayList<Value> parameters = new ArrayList<Value>(methodCall.getParameters());
            try {
                Value value = rpcHandler1.process(iq.getFrom(), methodCall.getMethodName(), parameters);
                return iq.createResult((Object)Rpc.ofMethodResponse(value));
            }
            catch (RpcException e1) {
                return iq.createResult((Object)Rpc.ofFaultResponse(e1.getFaultCode(), e1.getFaultString()));
            }
            catch (StanzaErrorException e1) {
                logger.log(System.Logger.Level.WARNING, e1.getMessage(), (Throwable)e1);
                return iq.createError(e1.getError());
            }
            catch (Throwable e1) {
                logger.log(System.Logger.Level.WARNING, e1.getMessage(), e1);
                return iq.createError(Condition.INTERNAL_SERVER_ERROR);
            }
        }
        return iq.createError(Condition.SERVICE_UNAVAILABLE);
    }
}

