/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.shim.model;

import java.time.OffsetDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.extensions.shim.model.Header;

@XmlRootElement
public final class Headers {
    public static final String NAMESPACE = "http://jabber.org/protocol/shim";
    private final List<Header> header = new ArrayList<Header>();

    private Headers() {
    }

    private Headers(Collection<Header> headers) {
        this.header.addAll(headers);
    }

    public static Headers of(Header ... headers) {
        return Headers.of(Arrays.asList(headers));
    }

    public static Headers of(Collection<Header> headers) {
        return new Headers(headers);
    }

    public static Headers of(Map<String, String> headers) {
        return Headers.of(headers.entrySet().stream().map(entry -> Header.of((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()));
    }

    public static Headers ofTimePeriod(OffsetDateTime start, OffsetDateTime stop) {
        if (start.isAfter(stop)) {
            throw new IllegalArgumentException("start date must not be after the start date.");
        }
        return Headers.of(Header.ofStartDate(start), Header.ofStopDate(stop));
    }

    public final String findValue(String name) {
        for (Header header : this.header) {
            if (!header.getName().equals(name)) continue;
            return header.getValue();
        }
        return null;
    }

    public final List<Header> getHeaders() {
        return Collections.unmodifiableList(this.header);
    }

    public final Headers withHeader(String name, String value) {
        return this.withHeader(Header.of(name, value));
    }

    public final Headers withHeader(Header header) {
        ArrayDeque<Header> headers = new ArrayDeque<Header>(this.header);
        headers.removeIf(h -> h.getName().equals(header.getName()));
        headers.add(header);
        return Headers.of(headers);
    }

    public final Headers withoutHeader(String name) {
        ArrayDeque<Header> headers = new ArrayDeque<Header>(this.header);
        headers.removeIf(h -> h.getName().equals(name));
        return Headers.of(headers);
    }

    public final String toString() {
        return "Headers: " + this.header;
    }
}

