/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.sm.StreamManager;
import rocks.xmpp.extensions.sm.model.StreamManagement;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedScheduledExecutorService;
import rocks.xmpp.websocket.net.WebSocketConnection;
import rocks.xmpp.websocket.net.client.WebSocketConnectionConfiguration;

public final class WebSocketClientConnection
extends WebSocketConnection {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"WebSocket Ping Scheduler"));
    private final StreamFeaturesManager streamFeaturesManager;
    private final StreamManager streamManager;
    private final Set<String> pings = new CopyOnWriteArraySet<String>();
    private ScheduledExecutorService executorService;
    private Future<?> pingFuture;
    private Future<?> pongFuture;

    WebSocketClientConnection(Session session, CompletableFuture<Void> closeFuture, XmppSession xmppSession, WebSocketConnectionConfiguration connectionConfiguration) {
        super(session, (StreamHandler)xmppSession, arg_0 -> ((XmppSession)xmppSession).notifyException(arg_0), closeFuture, (ConnectionConfiguration)connectionConfiguration);
        this.streamFeaturesManager = (StreamFeaturesManager)xmppSession.getManager(StreamFeaturesManager.class);
        this.streamManager = (StreamManager)xmppSession.getManager(StreamManager.class);
        this.streamFeaturesManager.addFeatureNegotiator((StreamFeatureNegotiator)this.streamManager);
        this.streamManager.reset();
        this.executorService = new QueuedScheduledExecutorService(EXECUTOR_SERVICE);
        session.addMessageHandler((MessageHandler)new PongHandler());
        if (connectionConfiguration.getPingInterval() != null && !connectionConfiguration.getPingInterval().isNegative() && !connectionConfiguration.getPingInterval().isZero()) {
            this.pingFuture = this.executorService.scheduleAtFixedRate(() -> {
                WebSocketClientConnection webSocketClientConnection = this;
                synchronized (webSocketClientConnection) {
                    try {
                        String uuid;
                        if (this.session.isOpen() && this.pings.add(uuid = UUID.randomUUID().toString())) {
                            this.session.getBasicRemote().sendPing(ByteBuffer.wrap(uuid.getBytes(StandardCharsets.UTF_8)));
                            this.pongFuture = this.executorService.schedule(() -> {
                                if (this.pings.remove(uuid)) {
                                    xmppSession.notifyException((Throwable)new XmppException("No WebSocket pong received in time."));
                                }
                            }, xmppSession.getConfiguration().getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (IOException e) {
                        xmppSession.notifyException((Throwable)e);
                    }
                }
            }, 0L, connectionConfiguration.getPingInterval().toMillis(), TimeUnit.MILLISECONDS);
        }
        this.closeFuture().whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                xmppSession.notifyException(throwable);
            }
        });
    }

    public final CompletableFuture<Void> send(StreamElement streamElement) {
        if (streamElement instanceof Stanza) {
            this.streamManager.markUnacknowledged((Stanza)streamElement);
        }
        return ((CompletableFuture)this.write(streamElement).thenRun(() -> {
            if (streamElement instanceof Stanza && this.streamManager.isActive() && this.streamManager.getRequestStrategy().test((Stanza)streamElement)) {
                this.write((StreamElement)StreamManagement.REQUEST);
            }
        })).thenRun(() -> ((WebSocketClientConnection)this).flush());
    }

    protected final void restartStream() {
        this.open(this.sessionOpen);
    }

    public final boolean isUsingAcknowledgements() {
        return this.streamManager.isActive();
    }

    protected CompletionStage<Void> closeConnection() {
        return super.closeConnection().thenRun(() -> {
            this.streamFeaturesManager.removeFeatureNegotiator((StreamFeatureNegotiator)this.streamManager);
            this.pings.clear();
            WebSocketClientConnection webSocketClientConnection = this;
            synchronized (webSocketClientConnection) {
                if (this.pingFuture != null) {
                    this.pingFuture.cancel(false);
                    this.pingFuture = null;
                }
                if (this.pongFuture != null) {
                    this.pongFuture.cancel(false);
                    this.pongFuture = null;
                }
                if (this.executorService != null) {
                    this.executorService.shutdown();
                    try {
                        if (!this.executorService.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                            this.executorService.shutdownNow();
                        }
                    }
                    catch (InterruptedException e) {
                        this.executorService.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                    this.executorService = null;
                }
            }
        });
    }

    private final class PongHandler
    implements MessageHandler.Whole<PongMessage> {
        private PongHandler() {
        }

        public final void onMessage(PongMessage message) {
            byte[] bytes = new byte[message.getApplicationData().limit()];
            message.getApplicationData().get(bytes);
            WebSocketClientConnection.this.pings.remove(new String(bytes, StandardCharsets.UTF_8));
        }
    }
}

