/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.SessionException;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.client.SslEngineConfigurator;
import org.glassfish.tyrus.client.ThreadPoolConfig;
import org.glassfish.tyrus.container.jdk.client.JdkClientContainer;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.dns.DnsResolver;
import rocks.xmpp.dns.TxtRecord;
import rocks.xmpp.websocket.codec.XmppWebSocketDecoder;
import rocks.xmpp.websocket.codec.XmppWebSocketEncoder;
import rocks.xmpp.websocket.net.client.WebSocketClientConnection;

public final class WebSocketConnectionConfiguration
extends ClientConnectionConfiguration {
    private static volatile WebSocketConnectionConfiguration defaultConfiguration;
    private final String path;
    private final Duration pingInterval;

    private WebSocketConnectionConfiguration(Builder builder) {
        super((ClientConnectionConfiguration.Builder)builder);
        this.path = builder.path;
        this.pingInterval = builder.pingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebSocketConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<WebSocketConnectionConfiguration> clazz = WebSocketConnectionConfiguration.class;
        synchronized (WebSocketConnectionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = WebSocketConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(WebSocketConnectionConfiguration configuration) {
        Class<WebSocketConnectionConfiguration> clazz = WebSocketConnectionConfiguration.class;
        synchronized (WebSocketConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public final String getPath() {
        return this.path;
    }

    public final Duration getPingInterval() {
        return this.pingInterval;
    }

    public final Connection createConnection(XmppSession xmppSession) throws Exception {
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        return new WebSocketClientConnection(this.createWebSocketSession(xmppSession, closeFuture), closeFuture, xmppSession, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createWebSocketSession(final XmppSession xmppSession, final CompletableFuture<Void> closeFuture) throws Exception {
        Session session;
        Proxy proxy;
        URI path;
        WebSocketConnectionConfiguration webSocketConnectionConfiguration = this;
        synchronized (webSocketConnectionConfiguration) {
            URI uri;
            int targetPort;
            String protocol;
            String string = protocol = this.getChannelEncryption() == ChannelEncryption.DIRECT ? "wss" : "ws";
            int n = this.getPort() > 0 ? this.getPort() : (targetPort = this.getChannelEncryption() == ChannelEncryption.DIRECT ? 5281 : 5280);
            if (this.getHostname() != null) {
                uri = new URI(protocol, null, this.getHostname(), targetPort, this.getPath(), null, null);
            } else if (xmppSession.getDomain() != null) {
                String resolvedUrl = WebSocketConnectionConfiguration.findWebSocketEndpoint(xmppSession.getDomain().toString(), xmppSession.getConfiguration().getNameServer(), this.getConnectTimeout());
                uri = resolvedUrl != null ? new URI(resolvedUrl) : new URI(protocol, null, xmppSession.getDomain().toString(), targetPort, this.getPath(), null, null);
            } else {
                throw new IllegalStateException("Neither an URL nor a domain given for a WebSocket connection.");
            }
            path = uri;
        }
        final AtomicBoolean handshakeSucceeded = new AtomicBoolean();
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().encoders(Collections.singletonList(XmppWebSocketEncoder.class)).decoders(Collections.singletonList(XmppWebSocketDecoder.class)).preferredSubprotocols(Collections.singletonList("xmpp")).configurator(new ClientEndpointConfig.Configurator(){

            public void afterResponse(HandshakeResponse response) {
                List responseHeader = (List)response.getHeaders().get("Sec-WebSocket-Protocol");
                if (responseHeader != null && responseHeader.contains("xmpp")) {
                    handshakeSucceeded.set(true);
                }
            }
        }).build();
        clientEndpointConfig.getUserProperties().put("marshaller", () -> ((XmppSession)xmppSession).createMarshaller());
        clientEndpointConfig.getUserProperties().put("unmarshaller", () -> ((XmppSession)xmppSession).createUnmarshaller());
        if (xmppSession.getDebugger() != null) {
            clientEndpointConfig.getUserProperties().put("onWrite", (arg_0, arg_1) -> ((XmppDebugger)xmppSession.getDebugger()).writeStanza(arg_0, arg_1));
            clientEndpointConfig.getUserProperties().put("onRead", (arg_0, arg_1) -> ((XmppDebugger)xmppSession.getDebugger()).readStanza(arg_0, arg_1));
        }
        clientEndpointConfig.getUserProperties().put("xmlOutputFactory", xmppSession.getConfiguration().getXmlOutputFactory());
        ClientManager client = ClientManager.createClient((String)JdkClientContainer.class.getName());
        if (this.getSSLContext() != null) {
            SslEngineConfigurator sslEngineConfigurator = new SslEngineConfigurator(this.getSSLContext());
            client.getProperties().put("org.glassfish.tyrus.client.sslEngineConfigurator", sslEngineConfigurator);
            sslEngineConfigurator.setHostnameVerifier(this.getHostnameVerifier());
        }
        ThreadPoolConfig config = ThreadPoolConfig.defaultConfig();
        config.setThreadFactory(xmppSession.getConfiguration().getThreadFactory("WebSocket Client"));
        client.getProperties().put("org.glassfish.tyrus.client.workerThreadPoolConfig", config);
        int connectTimeout = this.getConnectTimeout();
        if (connectTimeout > 0) {
            client.getProperties().put("org.glassfish.tyrus.client.ClientManager.ContainerTimeout", connectTimeout);
        }
        if ((proxy = this.getProxy()) != null && proxy.type() == Proxy.Type.HTTP) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            client.getProperties().put("org.glassfish.tyrus.client.proxy", "http://" + inetSocketAddress.getHostName() + ':' + inetSocketAddress.getPort());
        }
        if (!(session = client.connectToServer(new Endpoint(){

            public void onOpen(Session session, EndpointConfig config) {
                if (!handshakeSucceeded.get()) {
                    try {
                        String msg = "Server response did not include 'Sec-WebSocket-Protocol' header with value 'xmpp'.";
                        session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, msg));
                    }
                    catch (IOException e) {
                        xmppSession.notifyException((Throwable)e);
                    }
                }
            }

            public void onError(Session session, Throwable t) {
                xmppSession.notifyException(t);
            }

            public void onClose(Session session, CloseReason closeReason) {
                if (closeReason.getCloseCode() != CloseReason.CloseCodes.NORMAL_CLOSURE) {
                    closeFuture.completeExceptionally((Throwable)new SessionException(closeReason.toString(), null, session));
                }
                closeFuture.complete(null);
            }
        }, clientEndpointConfig, path)).isOpen()) {
            throw new IOException("Session could not be opened.");
        }
        return session;
    }

    private static String findWebSocketEndpoint(String xmppServiceDomain, String nameServer, long timeout) {
        try {
            List txtRecords = DnsResolver.resolveTXT((CharSequence)xmppServiceDomain, (String)nameServer, (long)timeout);
            for (TxtRecord txtRecord : txtRecords) {
                Map attributes = txtRecord.asAttributes();
                String url = (String)attributes.get("_xmpp-client-websocket");
                if (url == null) continue;
                return url;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public final String toString() {
        return "WebSocket connection configuration: " + (this.getChannelEncryption() == ChannelEncryption.DIRECT ? "wss" : "ws") + "://" + super.toString() + this.path;
    }

    public static final class Builder
    extends ClientConnectionConfiguration.Builder<Builder> {
        private String path;
        private Duration pingInterval;

        private Builder() {
            this.path("/ws/");
        }

        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Builder pingInterval(Duration pingInterval) {
            this.pingInterval = pingInterval;
            return this;
        }

        protected final Builder self() {
            return this;
        }

        public final WebSocketConnectionConfiguration build() {
            if (this.proxy != null && this.proxy.type() != Proxy.Type.HTTP && this.proxy.type() != Proxy.Type.DIRECT) {
                throw new UnsupportedOperationException("Non-HTTP proxies are not supported by WebSockets.");
            }
            if (this.channelEncryption != null && this.channelEncryption != ChannelEncryption.DISABLED && this.channelEncryption != ChannelEncryption.DIRECT) {
                throw new IllegalArgumentException("WebSocket connections only support ChannelEncryption.DIRECT (wss) or ChannelEncryption.DISABLED (ws).");
            }
            return new WebSocketConnectionConfiguration(this);
        }
    }
}

