/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.codec;

import java.io.Reader;
import java.io.StringReader;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import rocks.xmpp.core.stream.model.StreamElement;

public final class XmppWebSocketDecoder
implements Decoder.Text<StreamElement> {
    private Supplier<Unmarshaller> unmarshaller;
    private BiConsumer<String, StreamElement> onRead;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final StreamElement decode(String s) throws DecodeException {
        try (StringReader reader = new StringReader(s);){
            StreamElement streamElement = (StreamElement)this.unmarshaller.get().unmarshal((Reader)reader);
            if (this.onRead != null) {
                this.onRead.accept(s, streamElement);
            }
            StreamElement streamElement2 = streamElement;
            return streamElement2;
        }
        catch (JAXBException e) {
            throw new DecodeException(s, e.getMessage(), (Throwable)e);
        }
    }

    public final boolean willDecode(String s) {
        return true;
    }

    public final void init(EndpointConfig config) {
        this.unmarshaller = (Supplier)config.getUserProperties().get("unmarshaller");
        this.onRead = (BiConsumer)config.getUserProperties().get("onRead");
    }

    public final void destroy() {
        this.unmarshaller = null;
        this.onRead = null;
    }

    public static final class UserProperties {
        public static final String UNMARSHALLER = "unmarshaller";
        public static final String ON_READ = "onRead";

        private UserProperties() {
        }
    }
}

