/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.websocket.Session;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.AbstractConnection;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.websocket.model.Close;
import rocks.xmpp.websocket.model.Open;

public class WebSocketConnection
extends AbstractConnection {
    protected final Session session;
    private final CompletionStage<Void> closeFuture;
    private final StreamHandler streamHandler;
    private final Consumer<Throwable> onException;
    protected SessionOpen sessionOpen;

    public WebSocketConnection(Session session, StreamHandler streamHandler, Consumer<Throwable> onException, CompletableFuture<Void> closeFuture, ConnectionConfiguration connectionConfiguration) {
        super(connectionConfiguration);
        this.closeFuture = closeFuture;
        this.session = session;
        this.streamHandler = streamHandler;
        this.onException = onException;
        session.addMessageHandler(StreamElement.class, this::onRead);
    }

    private void onRead(StreamElement streamElement) {
        if (streamElement instanceof Open) {
            this.openedByPeer((Open)streamElement);
        } else if (streamElement instanceof Close) {
            this.closedByPeer();
        }
        try {
            if (this.streamHandler.handleElement((Object)streamElement)) {
                this.restartStream();
            }
        }
        catch (XmppException e) {
            this.onException.accept(e);
        }
    }

    protected void restartStream() {
    }

    protected final CompletionStage<Void> closeStream() {
        return this.send(new Close());
    }

    protected CompletionStage<Void> closeConnection() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.session.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public final CompletionStage<Void> closeFuture() {
        return this.closeFuture;
    }

    public CompletableFuture<Void> send(StreamElement streamElement) {
        CompletionStage future = this.write(streamElement);
        this.flush();
        return future;
    }

    public final CompletableFuture<Void> write(StreamElement streamElement) {
        CompletableFuture<Void> sendFuture = new CompletableFuture<Void>();
        this.session.getAsyncRemote().sendObject((Object)streamElement, result -> {
            if (result.isOK()) {
                sendFuture.complete(null);
            } else {
                sendFuture.completeExceptionally(result.getException());
            }
        });
        return sendFuture;
    }

    public final void flush() {
        try {
            this.session.getAsyncRemote().flushBatch();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final InetSocketAddress getRemoteAddress() {
        return InetSocketAddress.createUnresolved(this.session.getRequestURI().getHost(), this.session.getRequestURI().getPort());
    }

    public final CompletionStage<Void> open(SessionOpen sessionOpen) {
        this.sessionOpen = sessionOpen;
        return this.send(new Open(sessionOpen.getTo(), sessionOpen.getFrom(), sessionOpen.getId(), sessionOpen.getLanguage()));
    }

    public final boolean isSecure() {
        return this.session.isSecure() || this.getConfiguration().getChannelEncryption() == ChannelEncryption.DIRECT;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("WebSocket connection at ").append(this.session.getRequestURI());
        String streamId = this.getStreamId();
        if (streamId != null) {
            sb.append(" (").append(streamId).append(')');
        }
        return sb.toString();
    }
}

