/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.webservices.adminapi.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.roller.webservices.adminapi.sdk.Entry;
import org.apache.roller.webservices.adminapi.sdk.EntrySet;
import org.apache.roller.webservices.adminapi.sdk.UnexpectedRootElementException;
import org.apache.roller.webservices.adminapi.sdk.UserEntry;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class UserEntrySet
extends EntrySet {
    public UserEntrySet(String urlPrefix) {
        this.setHref(urlPrefix + "/" + "users");
    }

    public UserEntrySet(Document d, String urlPrefix) throws UnexpectedRootElementException {
        this.populate(d, urlPrefix);
    }

    public UserEntrySet(InputStream stream, String urlPrefix) throws JDOMException, IOException, UnexpectedRootElementException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(stream);
        this.populate(d, urlPrefix);
    }

    private void populate(Document d, String urlPrefix) throws UnexpectedRootElementException {
        Element root = d.getRootElement();
        String rootName = root.getName();
        if (!rootName.equals("users")) {
            throw new UnexpectedRootElementException("ERROR: Unexpected root element", "users", rootName);
        }
        List users = root.getChildren("user", NAMESPACE);
        if (users != null) {
            ArrayList<UserEntry> entries = new ArrayList<UserEntry>();
            Iterator i = users.iterator();
            while (i.hasNext()) {
                Element user = (Element)i.next();
                UserEntry entry = new UserEntry(user, urlPrefix);
                entries.add(entry);
            }
            this.setEntries(entries.toArray(new Entry[0]));
        }
        this.setHref(urlPrefix + "/" + "users");
    }

    public String getType() {
        return "users";
    }

    private static interface Tags {
        public static final String USERS = "users";
    }
}

