/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.itunes.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.itunes.AbstractITunesObject;
import com.sun.syndication.feed.module.itunes.EntryInformationImpl;
import com.sun.syndication.feed.module.itunes.FeedInformationImpl;
import com.sun.syndication.feed.module.itunes.types.Category;
import com.sun.syndication.feed.module.itunes.types.Duration;
import com.sun.syndication.feed.module.itunes.types.Subcategory;
import com.sun.syndication.io.ModuleParser;
import com.sun.syndication.io.WireFeedParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class ITunesParser
implements ModuleParser {
    static Logger log = Logger.getLogger(ITunesParser.class.getName());
    Namespace ns = Namespace.getNamespace((String)"http://www.itunes.com/dtds/podcast-1.0.dtd");

    public void setParser(WireFeedParser feedParser) {
    }

    public String getNamespaceUri() {
        return "http://www.itunes.com/dtds/podcast-1.0.dtd";
    }

    public Module parse(Element element) {
        AbstractITunesObject module = null;
        if (element.getName().equals("channel")) {
            Element image;
            FeedInformationImpl feedInfo = new FeedInformationImpl();
            module = feedInfo;
            Element owner = element.getChild("owner", this.ns);
            if (owner != null) {
                Element email;
                Element name = owner.getChild("name", this.ns);
                if (name != null) {
                    feedInfo.setOwnerName(name.getValue().trim());
                }
                if ((email = owner.getChild("email", this.ns)) != null) {
                    feedInfo.setOwnerEmailAddress(email.getValue().trim());
                }
            }
            if ((image = element.getChild("image", this.ns)) != null && image.getAttributeValue("href") != null) {
                try {
                    URL imageURL = new URL(image.getAttributeValue("href").trim());
                    feedInfo.setImage(imageURL);
                }
                catch (MalformedURLException e) {
                    log.finer("Malformed URL Exception reading itunes:image tag: " + image.getAttributeValue("href"));
                }
            }
            List categories = element.getChildren("category", this.ns);
            Iterator it = categories.iterator();
            while (it.hasNext()) {
                Element category = (Element)it.next();
                if (category == null || category.getAttribute("text") == null) continue;
                Category cat = new Category();
                cat.setName(category.getAttribute("text").getValue().trim());
                Element subcategory = category.getChild("category", this.ns);
                if (subcategory != null && subcategory.getAttribute("text") != null) {
                    Subcategory subcat = new Subcategory();
                    subcat.setName(subcategory.getAttribute("text").getValue().trim());
                    cat.setSubcategory(subcat);
                }
                feedInfo.getCategories().add(cat);
            }
        } else if (element.getName().equals("item")) {
            EntryInformationImpl entryInfo = new EntryInformationImpl();
            module = entryInfo;
            Element duration = element.getChild("duration", this.ns);
            if (duration != null && duration.getValue() != null) {
                Duration dur = new Duration(duration.getValue().trim());
                entryInfo.setDuration(dur);
            }
        }
        if (module != null) {
            Element summary;
            Element subtitle;
            Element keywords;
            Element explicit;
            Element block;
            Element author = element.getChild("author", this.ns);
            if (author != null && author.getText() != null) {
                module.setAuthor(author.getText());
            }
            if ((block = element.getChild("block", this.ns)) != null) {
                module.setBlock(true);
            }
            if ((explicit = element.getChild("explicit", this.ns)) != null && explicit.getValue() != null && explicit.getValue().trim().equalsIgnoreCase("yes")) {
                module.setExplicit(true);
            }
            if ((keywords = element.getChild("keywords", this.ns)) != null) {
                StringTokenizer tok = new StringTokenizer(this.getXmlInnerText(keywords).trim(), ",");
                String[] keywordsArray = new String[tok.countTokens()];
                int i = 0;
                while (tok.hasMoreTokens()) {
                    keywordsArray[i] = tok.nextToken();
                    ++i;
                }
                module.setKeywords(keywordsArray);
            }
            if ((subtitle = element.getChild("subtitle", this.ns)) != null) {
                module.setSubtitle(subtitle.getTextTrim());
            }
            if ((summary = element.getChild("summary", this.ns)) != null) {
                module.setSummary(summary.getTextTrim());
            }
        }
        return module;
    }

    protected String getXmlInnerText(Element e) {
        StringBuffer sb = new StringBuffer();
        XMLOutputter xo = new XMLOutputter();
        List children = e.getContent();
        sb.append(xo.outputString(children));
        return sb.toString();
    }
}

