/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.sle.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.sle.SleEntryImpl;
import com.sun.syndication.feed.module.sle.io.ModuleParser;
import com.sun.syndication.feed.module.sle.types.DateValue;
import com.sun.syndication.feed.module.sle.types.EntryValue;
import com.sun.syndication.feed.module.sle.types.NumberValue;
import com.sun.syndication.feed.module.sle.types.StringValue;
import com.sun.syndication.io.impl.DateParser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class ItemParser
implements com.sun.syndication.io.ModuleParser {
    public String getNamespaceUri() {
        return ModuleParser.TEMP.getURI();
    }

    public Module parse(Element element) {
        SleEntryImpl sle = new SleEntryImpl();
        ArrayList<EntryValue> values = new ArrayList<EntryValue>();
        List groups = element.getChildren("group", ModuleParser.TEMP);
        for (int i = 0; groups != null && i < groups.size(); ++i) {
            Element group = (Element)groups.get(i);
            StringValue value = new StringValue();
            value.setElement(group.getAttributeValue("element"));
            value.setLabel(group.getAttributeValue("label"));
            value.setValue(group.getAttributeValue("value"));
            if (group.getAttributeValue("ns") != null) {
                value.setNamespace(Namespace.getNamespace((String)group.getAttributeValue("ns")));
            }
            values.add(value);
            element.removeContent((Content)group);
        }
        sle.setGroupValues(values.toArray(new EntryValue[values.size()]));
        values = values.size() == 0 ? values : new ArrayList<EntryValue>();
        List sorts = element.getChildren("sort", ModuleParser.TEMP);
        for (int i = 0; sorts != null && i < sorts.size(); ++i) {
            EntryValue value;
            Element sort = (Element)sorts.get(i);
            String dataType = sort.getAttributeValue("data-type");
            if (dataType == null || dataType.equals("text")) {
                value = new StringValue();
                ((StringValue)value).setElement(sort.getAttributeValue("element"));
                ((StringValue)value).setLabel(sort.getAttributeValue("label"));
                ((StringValue)value).setValue(sort.getAttributeValue("value"));
                if (sort.getAttributeValue("ns") != null) {
                    ((StringValue)value).setNamespace(Namespace.getNamespace((String)sort.getAttributeValue("ns")));
                } else {
                    ((StringValue)value).setNamespace(Namespace.NO_NAMESPACE);
                }
                values.add(value);
                element.removeContent((Content)sort);
                continue;
            }
            if (dataType.equals("date")) {
                value = new DateValue();
                ((DateValue)value).setElement(sort.getAttributeValue("element"));
                ((DateValue)value).setLabel(sort.getAttributeValue("label"));
                if (sort.getAttributeValue("ns") != null) {
                    ((DateValue)value).setNamespace(Namespace.getNamespace((String)sort.getAttributeValue("ns")));
                } else {
                    ((DateValue)value).setNamespace(Namespace.NO_NAMESPACE);
                }
                Date dateValue = null;
                try {
                    dateValue = DateParser.parseRFC822((String)sort.getAttributeValue("value"));
                    dateValue = dateValue == null ? DateParser.parseW3CDateTime((String)sort.getAttributeValue("value")) : dateValue;
                }
                catch (Exception e) {
                    // empty catch block
                }
                ((DateValue)value).setValue(dateValue);
                values.add(value);
                element.removeContent((Content)sort);
                continue;
            }
            if (!dataType.equals("number")) continue;
            value = new NumberValue();
            ((NumberValue)value).setElement(sort.getAttributeValue("element"));
            ((NumberValue)value).setLabel(sort.getAttributeValue("label"));
            if (sort.getAttributeValue("ns") != null) {
                ((NumberValue)value).setNamespace(Namespace.getNamespace((String)sort.getAttributeValue("ns")));
            } else {
                ((NumberValue)value).setNamespace(Namespace.NO_NAMESPACE);
            }
            try {
                ((NumberValue)value).setValue(new BigDecimal(sort.getAttributeValue("value")));
                continue;
            }
            catch (NumberFormatException nfe) {
                values.add(value);
                element.removeContent((Content)sort);
            }
        }
        sle.setSortValues(values.toArray(new EntryValue[values.size()]));
        return sle;
    }
}

