/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.sse;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.sse.modules.Conflict;
import com.sun.syndication.feed.module.sse.modules.History;
import com.sun.syndication.feed.module.sse.modules.Related;
import com.sun.syndication.feed.module.sse.modules.SSEModule;
import com.sun.syndication.feed.module.sse.modules.Sharing;
import com.sun.syndication.feed.module.sse.modules.Sync;
import com.sun.syndication.feed.module.sse.modules.Update;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.DelegatingModuleParser;
import com.sun.syndication.io.WireFeedParser;
import com.sun.syndication.io.impl.DateParser;
import com.sun.syndication.io.impl.RSS20Parser;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class SSE091Parser
implements DelegatingModuleParser {
    static Logger log = Logger.getLogger(SSE091Parser.class.getName());
    private RSS20Parser rssParser;

    public void setFeedParser(WireFeedParser feedParser) {
        this.rssParser = (RSS20Parser)feedParser;
    }

    public String getNamespaceUri() {
        return "http://www.microsoft.com/schemas/rss/sse";
    }

    public Module parse(Element element) {
        SSEModule sseModule = null;
        String name = element.getName();
        if (name.equals("rss")) {
            sseModule = this.parseSharing(element);
        } else if (name.equals("item")) {
            sseModule = this.parseSync(element);
        }
        return sseModule;
    }

    private Sharing parseSharing(Element element) {
        Element root = this.getRoot(element);
        Sharing sharing = null;
        Element sharingChild = root.getChild("sharing", SSEModule.SSE_NS);
        if (sharingChild != null) {
            sharing = new Sharing();
            sharing.setOrdered(this.parseBooleanAttr(sharingChild, "ordered"));
            sharing.setSince(this.parseDateAttribute(sharingChild, "since"));
            sharing.setUntil(this.parseDateAttribute(sharingChild, "until"));
            sharing.setWindow(this.parseIntegerAttribute(sharingChild, "window"));
            sharing.setVersion(this.parseStringAttribute(sharingChild, "version"));
            this.parseRelated(root, sharing);
        }
        return sharing;
    }

    private void parseRelated(Element root, Sharing sharing) {
        Element relatedChild = root.getChild("related", SSEModule.SSE_NS);
        if (relatedChild != null) {
            Related related = new Related();
            related.setLink(this.parseStringAttribute(relatedChild, "link"));
            related.setSince(this.parseDateAttribute(relatedChild, "since"));
            related.setTitle(this.parseStringAttribute(relatedChild, "title"));
            related.setType(this.parseIntegerAttribute(relatedChild, "type"));
            related.setUntil(this.parseDateAttribute(relatedChild, "until"));
            sharing.setRelated(related);
        }
    }

    private Sync parseSync(Element element) {
        Element syncChild = element.getChild("sync", SSEModule.SSE_NS);
        Sync sync = null;
        if (syncChild != null) {
            sync = new Sync();
            sync.setId(this.parseStringAttribute(syncChild, "id"));
            sync.setVersion(this.parseIntegerAttribute(syncChild, "version"));
            sync.setDeleted(this.parseBooleanAttr(syncChild, "deleted"));
            sync.setConflict(this.parseBooleanAttr(syncChild, "conflict"));
            sync.setHistory(this.parseHistory(syncChild));
            sync.setConflicts(this.parseConflicts(syncChild));
        }
        return sync;
    }

    private List parseConflicts(Element syncElement) {
        ArrayList<Conflict> conflicts = null;
        List conflictsContent = syncElement.getContent((Filter)new ContentFilter("conflicts"));
        Iterator conflictsIter = conflictsContent.iterator();
        while (conflictsIter.hasNext()) {
            Element conflictsElement = (Element)conflictsIter.next();
            List conflictContent = conflictsElement.getContent((Filter)new ContentFilter("conflict"));
            Iterator conflictIter = conflictContent.iterator();
            while (conflictIter.hasNext()) {
                Element conflictElement = (Element)conflictIter.next();
                Conflict conflict = new Conflict();
                conflict.setBy(this.parseStringAttribute(conflictElement, "by"));
                conflict.setWhen(this.parseDateAttribute(conflictElement, "when"));
                conflict.setVersion(this.parseIntegerAttribute(conflictElement, "version"));
                List conflictItemContent = conflictElement.getContent((Filter)new ContentFilter("item"));
                Iterator conflictItemIter = conflictItemContent.iterator();
                while (conflictItemIter.hasNext()) {
                    Element conflictItemElement = (Element)conflictItemIter.next();
                    Element root = this.getRoot(conflictItemElement);
                    Item conflictItem = this.rssParser.parseItem(root, conflictItemElement);
                    conflict.setItem(conflictItem);
                    if (conflicts == null) {
                        conflicts = new ArrayList<Conflict>();
                    }
                    conflicts.add(conflict);
                }
            }
        }
        return conflicts;
    }

    private Element getRoot(Element start) {
        Element root = start;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        return root;
    }

    private History parseHistory(Element historyElement) {
        Element historyContent = this.getFirstContent(historyElement, "history");
        History history = null;
        if (historyContent != null) {
            history = new History();
            history.setBy(this.parseStringAttribute(historyContent, "by"));
            history.setWhen(this.parseDateAttribute(historyContent, "when"));
            this.parseUpdates(historyContent, history);
        }
        return history;
    }

    private Element getFirstContent(Element element, String name) {
        List filterList = element.getContent((Filter)new ContentFilter(name));
        Element firstContent = null;
        if (filterList != null && filterList.size() > 0) {
            firstContent = (Element)filterList.get(0);
        }
        return firstContent;
    }

    private void parseUpdates(Element historyChild, History history) {
        List updatedChildren = historyChild.getContent((Filter)new ContentFilter("update"));
        Iterator childIter = updatedChildren.iterator();
        while (childIter.hasNext()) {
            Element updateChild = (Element)childIter.next();
            Update update = new Update();
            update.setBy(this.parseStringAttribute(updateChild, "by"));
            update.setWhen(this.parseDateAttribute(updateChild, "when"));
            history.addUpdate(update);
        }
    }

    private String parseStringAttribute(Element syncChild, String attrName) {
        Attribute idAttribute = syncChild.getAttribute(attrName);
        return idAttribute != null ? idAttribute.getValue().trim() : null;
    }

    private Integer parseIntegerAttribute(Element sharingChild, String attrName) {
        Attribute integerAttribute = sharingChild.getAttribute(attrName);
        Integer integerAttr = null;
        if (integerAttribute != null) {
            try {
                integerAttr = new Integer(integerAttribute.getIntValue());
            }
            catch (DataConversionException e) {
                // empty catch block
            }
        }
        return integerAttr;
    }

    private Boolean parseBooleanAttr(Element sharingChild, String attrName) {
        Attribute attribute = sharingChild.getAttribute(attrName);
        Boolean attrValue = null;
        if (attribute != null) {
            try {
                attrValue = attribute.getBooleanValue();
            }
            catch (DataConversionException e) {
                // empty catch block
            }
        }
        return attrValue;
    }

    private Date parseDateAttribute(Element childElement, String attrName) {
        Attribute dateAttribute = childElement.getAttribute(attrName);
        Date date = null;
        if (dateAttribute != null) {
            String dateAttr = dateAttribute.getValue().trim();
            return DateParser.parseRFC822((String)dateAttr);
        }
        return date;
    }

    private static class ContentFilter
    implements Filter {
        private String name;

        private ContentFilter(String name) {
            this.name = name;
        }

        public boolean matches(Object object) {
            return object instanceof Element && this.name.equals(((Element)object).getName());
        }
    }
}

