/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import rs.iggy.clients.blocking.ConsumerGroupsClient;
import rs.iggy.clients.blocking.http.HttpClient;
import rs.iggy.consumergroup.ConsumerGroup;
import rs.iggy.consumergroup.ConsumerGroupDetails;
import rs.iggy.identifier.ConsumerId;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;

class ConsumerGroupsHttpClient
implements ConsumerGroupsClient {
    private final HttpClient httpClient;

    public ConsumerGroupsHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Optional<ConsumerGroupDetails> getConsumerGroup(StreamId streamId, TopicId topicId, ConsumerId groupId) {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(ConsumerGroupsHttpClient.path(streamId, topicId) + "/" + groupId, new NameValuePair[0]);
        return this.httpClient.executeWithOptionalResponse(request, ConsumerGroupDetails.class);
    }

    @Override
    public List<ConsumerGroup> getConsumerGroups(StreamId streamId, TopicId topicId) {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(ConsumerGroupsHttpClient.path(streamId, topicId), new NameValuePair[0]);
        return this.httpClient.execute(request, new TypeReference<List<ConsumerGroup>>(){});
    }

    @Override
    public ConsumerGroupDetails createConsumerGroup(StreamId streamId, TopicId topicId, Optional<Long> groupId, String name) {
        ClassicHttpRequest request = this.httpClient.preparePostRequest(ConsumerGroupsHttpClient.path(streamId, topicId), new CreateConsumerGroup(groupId, name));
        return this.httpClient.execute(request, new TypeReference<ConsumerGroupDetails>(){});
    }

    @Override
    public void deleteConsumerGroup(StreamId streamId, TopicId topicId, ConsumerId groupId) {
        ClassicHttpRequest request = this.httpClient.prepareDeleteRequest(ConsumerGroupsHttpClient.path(streamId, topicId) + "/" + groupId, new NameValuePair[0]);
        this.httpClient.execute(request);
    }

    @Override
    public void joinConsumerGroup(StreamId streamId, TopicId topicId, ConsumerId groupId) {
        throw new UnsupportedOperationException("Method not available in HTTP client");
    }

    @Override
    public void leaveConsumerGroup(StreamId streamId, TopicId topicId, ConsumerId groupId) {
        throw new UnsupportedOperationException("Method not available in HTTP client");
    }

    private static String path(StreamId streamId, TopicId topicId) {
        return "/streams/" + streamId + "/topics/" + topicId + "/consumer-groups";
    }

    private record CreateConsumerGroup(Optional<Long> groupId, String name) {
    }
}

