/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import java.math.BigInteger;
import java.util.Optional;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import rs.iggy.clients.blocking.ConsumerOffsetsClient;
import rs.iggy.clients.blocking.http.HttpClient;
import rs.iggy.consumergroup.Consumer;
import rs.iggy.consumeroffset.ConsumerOffsetInfo;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;

class ConsumerOffsetsHttpClient
implements ConsumerOffsetsClient {
    private static final String DEFAULT_PARTITION_ID = "1";
    private final HttpClient httpClient;

    public ConsumerOffsetsHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void storeConsumerOffset(StreamId streamId, TopicId topicId, Optional<Long> partitionId, Consumer consumer, BigInteger offset) {
        ClassicHttpRequest request = this.httpClient.preparePutRequest(ConsumerOffsetsHttpClient.path(streamId, topicId), new StoreConsumerOffset(consumer.id().toString(), partitionId, offset));
        this.httpClient.execute(request);
    }

    @Override
    public Optional<ConsumerOffsetInfo> getConsumerOffset(StreamId streamId, TopicId topicId, Optional<Long> partitionId, Consumer consumer) {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(ConsumerOffsetsHttpClient.path(streamId, topicId), new NameValuePair[]{new BasicNameValuePair("consumer_id", consumer.id().toString()), new BasicNameValuePair("partition_id", partitionId.map(Object::toString).orElse(DEFAULT_PARTITION_ID))});
        return this.httpClient.executeWithOptionalResponse(request, ConsumerOffsetInfo.class);
    }

    private static String path(StreamId streamId, TopicId topicId) {
        return "/streams/" + streamId + "/topics/" + topicId + "/consumer-offsets";
    }

    private record StoreConsumerOffset(String consumerId, Optional<Long> partitionId, BigInteger offset) {
    }
}

