/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.iggy.clients.blocking.http.ObjectMapperFactory;
import rs.iggy.clients.blocking.http.error.IggyHttpError;
import rs.iggy.clients.blocking.http.error.IggyHttpException;

class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private static final String AUTHORIZATION = "Authorization";
    private final String url;
    private final ObjectMapper objectMapper = ObjectMapperFactory.getInstance();
    private Optional<String> token = Optional.empty();

    HttpClient(String url) {
        this.url = url;
    }

    void setToken(Optional<String> token) {
        this.token = token;
    }

    <T> T execute(ClassicHttpRequest request, Class<T> clazz) {
        return this.execute(request, this.objectMapper.constructType(clazz));
    }

    <T> T execute(ClassicHttpRequest request, TypeReference<T> typeReference) {
        return this.execute(request, this.objectMapper.constructType(typeReference));
    }

    private <T> T execute(ClassicHttpRequest request, JavaType type) {
        return this.executeRequest(request, response -> this.handleTypedResponse(response, type));
    }

    public <T> Optional<T> executeWithOptionalResponse(ClassicHttpRequest request, Class<T> clazz) {
        return this.executeWithOptionalResponse(request, this.objectMapper.constructType(clazz));
    }

    private <T> Optional<T> executeWithOptionalResponse(ClassicHttpRequest request, JavaType type) {
        return (Optional)this.executeRequest(request, response -> {
            if (response.getCode() == 404) {
                return Optional.empty();
            }
            return Optional.of(this.handleTypedResponse(response, type));
        });
    }

    String executeWithStringResponse(ClassicHttpRequest request) {
        return (String)this.executeRequest(request, response -> {
            this.handleErrorResponse(response);
            return new String(response.getEntity().getContent().readAllBytes());
        });
    }

    void execute(ClassicHttpRequest request) {
        this.executeRequest(request, response -> {
            this.handleErrorResponse(response);
            return "";
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeRequest(ClassicHttpRequest request, HttpClientResponseHandler<T> responseHandler) {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            Object object = client.execute(request, responseHandler);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    ClassicHttpRequest prepareGetRequest(String path, NameValuePair ... params) {
        return ClassicRequestBuilder.get((String)(this.url + path)).setHeader(AUTHORIZATION, this.getBearerToken()).addParameters(params).build();
    }

    ClassicHttpRequest preparePostRequest(String path, Object body) {
        ClassicRequestBuilder builder = ClassicRequestBuilder.post((String)(this.url + path)).setHeader(AUTHORIZATION, this.getBearerToken());
        return this.addRequestBody(builder, body);
    }

    ClassicHttpRequest preparePutRequest(String path, Object body) {
        ClassicRequestBuilder builder = ClassicRequestBuilder.put((String)(this.url + path)).setHeader(AUTHORIZATION, this.getBearerToken());
        return this.addRequestBody(builder, body);
    }

    ClassicHttpRequest prepareDeleteRequest(String path, NameValuePair ... params) {
        return ClassicRequestBuilder.delete((String)(this.url + path)).setHeader(AUTHORIZATION, this.getBearerToken()).addParameters(params).build();
    }

    private ClassicHttpRequest addRequestBody(ClassicRequestBuilder requestBuilder, Object body) {
        try {
            String encodedBody = this.objectMapper.writeValueAsString(body);
            log.debug("Request body: {}", (Object)encodedBody);
            return requestBuilder.setHeader("Content-Type", "application/json").setEntity(encodedBody).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T handleTypedResponse(ClassicHttpResponse response, JavaType type) throws IOException {
        this.handleErrorResponse(response);
        return (T)this.objectMapper.readValue(response.getEntity().getContent(), type);
    }

    private void handleErrorResponse(ClassicHttpResponse response) throws IOException {
        if (!HttpClient.isSuccessful(response.getCode())) {
            IggyHttpError error = (IggyHttpError)this.objectMapper.readValue(response.getEntity().getContent(), IggyHttpError.class);
            throw new IggyHttpException(error);
        }
    }

    private String getBearerToken() {
        return this.token.map(t -> "Bearer " + t).orElse("");
    }

    private static boolean isSuccessful(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

