/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import rs.iggy.clients.blocking.PartitionsClient;
import rs.iggy.clients.blocking.http.HttpClient;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;

class PartitionsHttpClient
implements PartitionsClient {
    private static final String STREAMS = "/streams";
    private static final String TOPICS = "/topics";
    private static final String PARTITIONS = "/partitions";
    private final HttpClient httpClient;

    public PartitionsHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void createPartitions(StreamId streamId, TopicId topicId, Long partitionsCount) {
        ClassicHttpRequest request = this.httpClient.preparePostRequest("/streams/" + streamId + "/topics/" + topicId + PARTITIONS, new CreatePartitions(partitionsCount));
        this.httpClient.execute(request);
    }

    @Override
    public void deletePartitions(StreamId streamId, TopicId topicId, Long partitionsCount) {
        ClassicHttpRequest request = this.httpClient.prepareDeleteRequest("/streams/" + streamId + "/topics/" + topicId + PARTITIONS, new NameValuePair[]{new BasicNameValuePair("partitions_count", partitionsCount.toString())});
        this.httpClient.execute(request);
    }

    private record CreatePartitions(Long partitionsCount) {
    }
}

