/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigInteger;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import rs.iggy.clients.blocking.PersonalAccessTokensClient;
import rs.iggy.clients.blocking.http.HttpClient;
import rs.iggy.personalaccesstoken.PersonalAccessTokenInfo;
import rs.iggy.personalaccesstoken.RawPersonalAccessToken;
import rs.iggy.user.IdentityInfo;
import rs.iggy.user.TokenInfo;

class PersonalAccessTokensHttpClient
implements PersonalAccessTokensClient {
    private static final String PERSONAL_ACCESS_TOKENS = "/personal-access-tokens";
    private final HttpClient httpClient;

    public PersonalAccessTokensHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public RawPersonalAccessToken createPersonalAccessToken(String name, BigInteger expiry) {
        ClassicHttpRequest request = this.httpClient.preparePostRequest(PERSONAL_ACCESS_TOKENS, new CreatePersonalAccessToken(name, expiry));
        return this.httpClient.execute(request, new TypeReference<RawPersonalAccessToken>(){});
    }

    @Override
    public List<PersonalAccessTokenInfo> getPersonalAccessTokens() {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(PERSONAL_ACCESS_TOKENS, new NameValuePair[0]);
        return this.httpClient.execute(request, new TypeReference<List<PersonalAccessTokenInfo>>(){});
    }

    @Override
    public void deletePersonalAccessToken(String name) {
        ClassicHttpRequest request = this.httpClient.prepareDeleteRequest("/personal-access-tokens/" + name, new NameValuePair[0]);
        this.httpClient.execute(request);
    }

    @Override
    public IdentityInfo loginWithPersonalAccessToken(String token) {
        ClassicHttpRequest request = this.httpClient.preparePostRequest("/personal-access-tokens/login", new LoginWithPersonalAccessToken(token));
        IdentityInfo response = this.httpClient.execute(request, IdentityInfo.class);
        this.httpClient.setToken(response.accessToken().map(TokenInfo::token));
        return response;
    }

    record CreatePersonalAccessToken(String name, BigInteger expiry) {
    }

    record LoginWithPersonalAccessToken(String token) {
    }
}

