/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import rs.iggy.clients.blocking.StreamsClient;
import rs.iggy.clients.blocking.http.HttpClient;
import rs.iggy.identifier.StreamId;
import rs.iggy.stream.StreamBase;
import rs.iggy.stream.StreamDetails;

class StreamsHttpClient
implements StreamsClient {
    private static final String STREAMS = "/streams";
    private final HttpClient httpClient;

    public StreamsHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Optional<StreamDetails> getStream(StreamId streamId) {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest("/streams/" + streamId, new NameValuePair[0]);
        return this.httpClient.executeWithOptionalResponse(request, StreamDetails.class);
    }

    @Override
    public List<StreamBase> getStreams() {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(STREAMS, new NameValuePair[0]);
        return this.httpClient.execute(request, new TypeReference<List<StreamBase>>(){});
    }

    @Override
    public StreamDetails createStream(Optional<Long> streamId, String name) {
        ClassicHttpRequest request = this.httpClient.preparePostRequest(STREAMS, new CreateStream(streamId, name));
        return this.httpClient.execute(request, new TypeReference<StreamDetails>(){});
    }

    @Override
    public void updateStream(StreamId streamId, String name) {
        ClassicHttpRequest request = this.httpClient.preparePutRequest("/streams/" + streamId, new UpdateStream(name));
        this.httpClient.execute(request);
    }

    @Override
    public void deleteStream(StreamId streamId) {
        ClassicHttpRequest request = this.httpClient.prepareDeleteRequest("/streams/" + streamId, new NameValuePair[0]);
        this.httpClient.execute(request);
    }

    record CreateStream(Optional<Long> streamId, String name) {
    }

    record UpdateStream(String name) {
    }
}

