/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import rs.iggy.clients.blocking.SystemClient;
import rs.iggy.clients.blocking.http.HttpClient;
import rs.iggy.system.ClientInfo;
import rs.iggy.system.ClientInfoDetails;
import rs.iggy.system.Stats;

class SystemHttpClient
implements SystemClient {
    private static final String STATS = "/stats";
    private static final String CLIENTS = "/clients";
    private static final String PING = "/ping";
    private final HttpClient httpClient;

    public SystemHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Stats getStats() {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(STATS, new NameValuePair[0]);
        return this.httpClient.execute(request, Stats.class);
    }

    @Override
    public ClientInfoDetails getMe() {
        throw new UnsupportedOperationException("Method not available in HTTP client");
    }

    @Override
    public ClientInfoDetails getClient(Long clientId) {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest("/clients/" + clientId, new NameValuePair[0]);
        return this.httpClient.execute(request, ClientInfoDetails.class);
    }

    @Override
    public List<ClientInfo> getClients() {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(CLIENTS, new NameValuePair[0]);
        return this.httpClient.execute(request, new TypeReference<List<ClientInfo>>(){});
    }

    @Override
    public String ping() {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(PING, new NameValuePair[0]);
        return this.httpClient.executeWithStringResponse(request);
    }
}

