/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import rs.iggy.clients.blocking.TopicsClient;
import rs.iggy.clients.blocking.http.HttpClient;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;
import rs.iggy.topic.CompressionAlgorithm;
import rs.iggy.topic.Topic;
import rs.iggy.topic.TopicDetails;

class TopicsHttpClient
implements TopicsClient {
    private static final String STREAMS = "/streams";
    private static final String TOPICS = "/topics";
    private final HttpClient httpClient;

    public TopicsHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Optional<TopicDetails> getTopic(StreamId streamId, TopicId topicId) {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest("/streams/" + streamId + "/topics/" + topicId, new NameValuePair[0]);
        return this.httpClient.executeWithOptionalResponse(request, TopicDetails.class);
    }

    @Override
    public List<Topic> getTopics(StreamId streamId) {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest("/streams/" + streamId + TOPICS, new NameValuePair[0]);
        return this.httpClient.execute(request, new TypeReference<List<Topic>>(){});
    }

    @Override
    public TopicDetails createTopic(StreamId streamId, Optional<Long> topicId, Long partitionsCount, CompressionAlgorithm compressionAlgorithm, BigInteger messageExpiry, BigInteger maxTopicSize, Optional<Short> replicationFactor, String name) {
        ClassicHttpRequest request = this.httpClient.preparePostRequest("/streams/" + streamId + TOPICS, new CreateTopic(topicId, partitionsCount, compressionAlgorithm, messageExpiry, maxTopicSize, replicationFactor, name));
        return this.httpClient.execute(request, new TypeReference<TopicDetails>(){});
    }

    @Override
    public void updateTopic(StreamId streamId, TopicId topicId, CompressionAlgorithm compressionAlgorithm, BigInteger messageExpiry, BigInteger maxTopicSize, Optional<Short> replicationFactor, String name) {
        ClassicHttpRequest request = this.httpClient.preparePutRequest("/streams/" + streamId + "/topics/" + topicId, new UpdateTopic(compressionAlgorithm, messageExpiry, maxTopicSize, replicationFactor, name));
        this.httpClient.execute(request);
    }

    @Override
    public void deleteTopic(StreamId streamId, TopicId topicId) {
        ClassicHttpRequest request = this.httpClient.prepareDeleteRequest("/streams/" + streamId + "/topics/" + topicId, new NameValuePair[0]);
        this.httpClient.execute(request);
    }

    record CreateTopic(Optional<Long> topicId, Long partitionsCount, CompressionAlgorithm compressionAlgorithm, BigInteger messageExpiry, BigInteger maxTopicSize, Optional<Short> replicationFactor, String name) {
    }

    record UpdateTopic(CompressionAlgorithm compressionAlgorithm, BigInteger messageExpiry, BigInteger maxTopicSize, Optional<Short> replicationFactor, String name) {
    }
}

