/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.http;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import rs.iggy.clients.blocking.UsersClient;
import rs.iggy.clients.blocking.http.HttpClient;
import rs.iggy.identifier.UserId;
import rs.iggy.user.IdentityInfo;
import rs.iggy.user.Permissions;
import rs.iggy.user.TokenInfo;
import rs.iggy.user.UserInfo;
import rs.iggy.user.UserInfoDetails;
import rs.iggy.user.UserStatus;

class UsersHttpClient
implements UsersClient {
    private static final String USERS = "/users";
    private final HttpClient httpClient;

    public UsersHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Optional<UserInfoDetails> getUser(UserId userId) {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest("/users/" + userId, new NameValuePair[0]);
        return this.httpClient.executeWithOptionalResponse(request, UserInfoDetails.class);
    }

    @Override
    public List<UserInfo> getUsers() {
        ClassicHttpRequest request = this.httpClient.prepareGetRequest(USERS, new NameValuePair[0]);
        return this.httpClient.execute(request, new TypeReference<List<UserInfo>>(){});
    }

    @Override
    public UserInfoDetails createUser(String username, String password, UserStatus status, Optional<Permissions> permissions) {
        ClassicHttpRequest request = this.httpClient.preparePostRequest(USERS, new CreateUser(username, password, status, permissions));
        return this.httpClient.execute(request, new TypeReference<UserInfoDetails>(){});
    }

    @Override
    public void deleteUser(UserId userId) {
        ClassicHttpRequest request = this.httpClient.prepareDeleteRequest("/users/" + userId, new NameValuePair[0]);
        this.httpClient.execute(request);
    }

    @Override
    public void updateUser(UserId userId, Optional<String> username, Optional<UserStatus> status) {
        ClassicHttpRequest request = this.httpClient.preparePutRequest("/users/" + userId, new UpdateUser(username, status));
        this.httpClient.execute(request);
    }

    @Override
    public void updatePermissions(UserId userId, Optional<Permissions> permissions) {
        ClassicHttpRequest request = this.httpClient.preparePutRequest("/users/" + userId + "/permissions", new UpdatePermissions(permissions));
        this.httpClient.execute(request);
    }

    @Override
    public void changePassword(UserId userId, String currentPassword, String newPassword) {
        ClassicHttpRequest request = this.httpClient.preparePutRequest("/users/" + userId + "/password", new ChangePassword(currentPassword, newPassword));
        this.httpClient.execute(request);
    }

    @Override
    public IdentityInfo login(String username, String password) {
        ClassicHttpRequest request = this.httpClient.preparePostRequest("/users/login", new Login(username, password));
        IdentityInfo response = this.httpClient.execute(request, IdentityInfo.class);
        this.httpClient.setToken(response.accessToken().map(TokenInfo::token));
        return response;
    }

    @Override
    public void logout() {
        ClassicHttpRequest request = this.httpClient.prepareDeleteRequest("/users/logout", new NameValuePair[0]);
        this.httpClient.execute(request);
        this.httpClient.setToken(Optional.empty());
    }

    private record CreateUser(String username, String password, UserStatus status, Optional<Permissions> permissions) {
    }

    private record UpdateUser(Optional<String> username, Optional<UserStatus> status) {
    }

    private record UpdatePermissions(Optional<Permissions> permissions) {
    }

    private record ChangePassword(String currentPassword, String newPassword) {
    }

    record Login(String username, String password) {
    }
}

