/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import rs.iggy.consumergroup.ConsumerGroup;
import rs.iggy.consumergroup.ConsumerGroupDetails;
import rs.iggy.consumergroup.ConsumerGroupMember;
import rs.iggy.consumeroffset.ConsumerOffsetInfo;
import rs.iggy.message.BytesMessageId;
import rs.iggy.message.HeaderKind;
import rs.iggy.message.HeaderValue;
import rs.iggy.message.Message;
import rs.iggy.message.MessageState;
import rs.iggy.message.PolledMessages;
import rs.iggy.partition.Partition;
import rs.iggy.personalaccesstoken.PersonalAccessTokenInfo;
import rs.iggy.personalaccesstoken.RawPersonalAccessToken;
import rs.iggy.stream.StreamBase;
import rs.iggy.stream.StreamDetails;
import rs.iggy.system.ClientInfo;
import rs.iggy.system.ClientInfoDetails;
import rs.iggy.system.ConsumerGroupInfo;
import rs.iggy.system.Stats;
import rs.iggy.topic.CompressionAlgorithm;
import rs.iggy.topic.Topic;
import rs.iggy.topic.TopicDetails;
import rs.iggy.user.GlobalPermissions;
import rs.iggy.user.Permissions;
import rs.iggy.user.StreamPermissions;
import rs.iggy.user.TopicPermissions;
import rs.iggy.user.UserInfo;
import rs.iggy.user.UserInfoDetails;
import rs.iggy.user.UserStatus;

final class BytesDeserializer {
    private BytesDeserializer() {
    }

    static StreamBase readStreamBase(ByteBuf response) {
        long streamId = response.readUnsignedIntLE();
        BigInteger createdAt = BytesDeserializer.readU64AsBigInteger(response);
        long topicsCount = response.readUnsignedIntLE();
        BigInteger size = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger messagesCount = BytesDeserializer.readU64AsBigInteger(response);
        byte nameLength = response.readByte();
        String name = response.readCharSequence((int)nameLength, StandardCharsets.UTF_8).toString();
        return new StreamBase(streamId, createdAt, name, size.toString(), messagesCount, topicsCount);
    }

    static StreamDetails readStreamDetails(ByteBuf response) {
        StreamBase streamBase = BytesDeserializer.readStreamBase(response);
        ArrayList<Topic> topics = new ArrayList<Topic>();
        if (response.isReadable()) {
            topics.add(BytesDeserializer.readTopic(response));
        }
        return new StreamDetails(streamBase, topics);
    }

    public static TopicDetails readTopicDetails(ByteBuf response) {
        Topic topic = BytesDeserializer.readTopic(response);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        while (response.isReadable()) {
            partitions.add(BytesDeserializer.readPartition(response));
        }
        return new TopicDetails(topic, partitions);
    }

    static Partition readPartition(ByteBuf response) {
        long partitionId = response.readUnsignedIntLE();
        BigInteger createdAt = BytesDeserializer.readU64AsBigInteger(response);
        long segmentsCount = response.readUnsignedIntLE();
        BigInteger currentOffset = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger size = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger messagesCount = BytesDeserializer.readU64AsBigInteger(response);
        return new Partition(partitionId, createdAt, segmentsCount, currentOffset, size.toString(), messagesCount);
    }

    public static Topic readTopic(ByteBuf response) {
        long topicId = response.readUnsignedIntLE();
        BigInteger createdAt = BytesDeserializer.readU64AsBigInteger(response);
        long partitionsCount = response.readUnsignedIntLE();
        BigInteger messageExpiry = BytesDeserializer.readU64AsBigInteger(response);
        byte compressionAlgorithmCode = response.readByte();
        BigInteger maxTopicSize = BytesDeserializer.readU64AsBigInteger(response);
        byte replicationFactor = response.readByte();
        BigInteger size = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger messagesCount = BytesDeserializer.readU64AsBigInteger(response);
        byte nameLength = response.readByte();
        String name = response.readCharSequence((int)nameLength, StandardCharsets.UTF_8).toString();
        return new Topic(topicId, createdAt, name, size.toString(), messageExpiry, CompressionAlgorithm.fromCode(compressionAlgorithmCode), maxTopicSize, Short.valueOf(replicationFactor), messagesCount, partitionsCount);
    }

    public static ConsumerGroupDetails readConsumerGroupDetails(ByteBuf response) {
        ConsumerGroup consumerGroup = BytesDeserializer.readConsumerGroup(response);
        ArrayList<ConsumerGroupMember> members = new ArrayList<ConsumerGroupMember>();
        while (response.isReadable()) {
            members.add(BytesDeserializer.readConsumerGroupMember(response));
        }
        return new ConsumerGroupDetails(consumerGroup, members);
    }

    static ConsumerGroupMember readConsumerGroupMember(ByteBuf response) {
        long memberId = response.readUnsignedIntLE();
        long partitionsCount = response.readUnsignedIntLE();
        ArrayList<Long> partitionIds = new ArrayList<Long>();
        int i = 0;
        while ((long)i < partitionsCount) {
            partitionIds.add(response.readUnsignedIntLE());
            ++i;
        }
        return new ConsumerGroupMember(memberId, partitionsCount, partitionIds);
    }

    public static ConsumerGroup readConsumerGroup(ByteBuf response) {
        long groupId = response.readUnsignedIntLE();
        long partitionsCount = response.readUnsignedIntLE();
        long membersCount = response.readUnsignedIntLE();
        byte nameLength = response.readByte();
        String name = response.readCharSequence((int)nameLength, StandardCharsets.UTF_8).toString();
        return new ConsumerGroup(groupId, name, partitionsCount, membersCount);
    }

    public static ConsumerOffsetInfo readConsumerOffsetInfo(ByteBuf response) {
        long partitionId = response.readUnsignedIntLE();
        BigInteger currentOffset = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger storedOffset = BytesDeserializer.readU64AsBigInteger(response);
        return new ConsumerOffsetInfo(partitionId, currentOffset, storedOffset);
    }

    public static PolledMessages readPolledMessages(ByteBuf response) {
        long partitionId = response.readUnsignedIntLE();
        BigInteger currentOffset = BytesDeserializer.readU64AsBigInteger(response);
        long _messagesCount = response.readUnsignedIntLE();
        ArrayList<Message> messages = new ArrayList<Message>();
        while (response.isReadable()) {
            messages.add(BytesDeserializer.readMessage(response));
        }
        return new PolledMessages(partitionId, currentOffset, messages);
    }

    static Message readMessage(ByteBuf response) {
        BigInteger offset = BytesDeserializer.readU64AsBigInteger(response);
        byte stateCode = response.readByte();
        MessageState state = MessageState.fromCode(stateCode);
        BigInteger timestamp = BytesDeserializer.readU64AsBigInteger(response);
        BytesMessageId id = BytesDeserializer.readBytesMessageId(response);
        long checksum = response.readUnsignedIntLE();
        long headersLength = response.readUnsignedIntLE();
        Optional<Map<String, HeaderValue>> headers = Optional.empty();
        if (headersLength > 0L) {
            HashMap<String, HeaderValue> headersMap = new HashMap<String, HeaderValue>();
            ByteBuf headersBytes = response.readBytes(BytesDeserializer.toInt(headersLength));
            while (headersBytes.isReadable()) {
                long keyLength = headersBytes.readUnsignedIntLE();
                String key = headersBytes.readCharSequence(BytesDeserializer.toInt(keyLength), StandardCharsets.UTF_8).toString();
                byte kindCode = headersBytes.readByte();
                HeaderKind kind = HeaderKind.fromCode(kindCode);
                long valueLength = headersBytes.readUnsignedIntLE();
                CharSequence value = headersBytes.readCharSequence(BytesDeserializer.toInt(valueLength), StandardCharsets.UTF_8);
                headersMap.put(key, new HeaderValue(kind, String.valueOf(value)));
            }
            headers = Optional.of(headersMap);
        }
        long payloadLength = response.readUnsignedIntLE();
        byte[] payload = BytesDeserializer.newByteArray(payloadLength);
        response.readBytes(payload);
        return new Message(offset, state, timestamp, id, checksum, headers, payload);
    }

    static Stats readStats(ByteBuf response) {
        long processId = response.readUnsignedIntLE();
        float cpuUsage = response.readFloatLE();
        float totalCpuUsage = response.readFloatLE();
        BigInteger memoryUsage = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger totalMemory = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger availableMemory = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger runTime = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger startTime = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger readBytes = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger writtenBytes = BytesDeserializer.readU64AsBigInteger(response);
        BigInteger messagesSizeBytes = BytesDeserializer.readU64AsBigInteger(response);
        long streamsCount = response.readUnsignedIntLE();
        long topicsCount = response.readUnsignedIntLE();
        long partitionsCount = response.readUnsignedIntLE();
        long segmentsCount = response.readUnsignedIntLE();
        BigInteger messagesCount = BytesDeserializer.readU64AsBigInteger(response);
        long clientsCount = response.readUnsignedIntLE();
        long consumerGroupsCount = response.readUnsignedIntLE();
        long hostnameLength = response.readUnsignedIntLE();
        String hostname = response.readCharSequence(BytesDeserializer.toInt(hostnameLength), StandardCharsets.UTF_8).toString();
        long osNameLength = response.readUnsignedIntLE();
        String osName = response.readCharSequence(BytesDeserializer.toInt(osNameLength), StandardCharsets.UTF_8).toString();
        long osVersionLength = response.readUnsignedIntLE();
        String osVersion = response.readCharSequence(BytesDeserializer.toInt(osVersionLength), StandardCharsets.UTF_8).toString();
        long kernelVersionLength = response.readUnsignedIntLE();
        String kernelVersion = response.readCharSequence(BytesDeserializer.toInt(kernelVersionLength), StandardCharsets.UTF_8).toString();
        return new Stats(processId, Float.valueOf(cpuUsage), Float.valueOf(totalCpuUsage), memoryUsage.toString(), totalMemory.toString(), availableMemory.toString(), runTime, startTime, readBytes.toString(), writtenBytes.toString(), messagesSizeBytes.toString(), streamsCount, topicsCount, partitionsCount, segmentsCount, messagesCount, clientsCount, consumerGroupsCount, hostname, osName, osVersion, kernelVersion);
    }

    static ClientInfoDetails readClientInfoDetails(ByteBuf response) {
        ClientInfo clientInfo = BytesDeserializer.readClientInfo(response);
        ArrayList<ConsumerGroupInfo> consumerGroups = new ArrayList<ConsumerGroupInfo>();
        int i = 0;
        while ((long)i < clientInfo.consumerGroupsCount()) {
            consumerGroups.add(BytesDeserializer.readConsumerGroupInfo(response));
            ++i;
        }
        return new ClientInfoDetails(clientInfo, consumerGroups);
    }

    static ClientInfo readClientInfo(ByteBuf response) {
        long clientId = response.readUnsignedIntLE();
        long userId = response.readUnsignedIntLE();
        Optional<Long> userIdOptional = Optional.empty();
        if (userId != 0L) {
            userIdOptional = Optional.of(userId);
        }
        byte transport = response.readByte();
        String transportString = "Tcp";
        if (transport == 2) {
            transportString = "Quic";
        }
        long addressLength = response.readUnsignedIntLE();
        String address = response.readCharSequence(BytesDeserializer.toInt(addressLength), StandardCharsets.UTF_8).toString();
        long consumerGroupsCount = response.readUnsignedIntLE();
        return new ClientInfo(clientId, userIdOptional, address, transportString, consumerGroupsCount);
    }

    static ConsumerGroupInfo readConsumerGroupInfo(ByteBuf response) {
        long streamId = response.readUnsignedIntLE();
        long topicId = response.readUnsignedIntLE();
        long groupId = response.readUnsignedIntLE();
        return new ConsumerGroupInfo(streamId, topicId, groupId);
    }

    static UserInfoDetails readUserInfoDetails(ByteBuf response) {
        UserInfo userInfo = BytesDeserializer.readUserInfo(response);
        Optional<Permissions> permissionsOptional = Optional.empty();
        if (response.readBoolean()) {
            Permissions permissions = BytesDeserializer.readPermissions(response);
            permissionsOptional = Optional.of(permissions);
        }
        return new UserInfoDetails(userInfo, permissionsOptional);
    }

    static Permissions readPermissions(ByteBuf response) {
        long _permissionsLength = response.readUnsignedIntLE();
        GlobalPermissions globalPermissions = BytesDeserializer.readGlobalPermissions(response);
        HashMap<Long, StreamPermissions> streamPermissionsMap = new HashMap<Long, StreamPermissions>();
        while (response.readBoolean()) {
            long streamId = response.readUnsignedIntLE();
            StreamPermissions streamPermissions = BytesDeserializer.readStreamPermissions(response);
            streamPermissionsMap.put(streamId, streamPermissions);
        }
        return new Permissions(globalPermissions, streamPermissionsMap);
    }

    static StreamPermissions readStreamPermissions(ByteBuf response) {
        boolean manageStream = response.readBoolean();
        boolean readStream = response.readBoolean();
        boolean manageTopics = response.readBoolean();
        boolean readTopics = response.readBoolean();
        boolean pollMessages = response.readBoolean();
        boolean sendMessages = response.readBoolean();
        HashMap<Long, TopicPermissions> topicPermissionsMap = new HashMap<Long, TopicPermissions>();
        while (response.readBoolean()) {
            long topicId = response.readUnsignedIntLE();
            TopicPermissions topicPermissions = BytesDeserializer.readTopicPermissions(response);
            topicPermissionsMap.put(topicId, topicPermissions);
        }
        return new StreamPermissions(manageStream, readStream, manageTopics, readTopics, pollMessages, sendMessages, topicPermissionsMap);
    }

    static TopicPermissions readTopicPermissions(ByteBuf response) {
        boolean manageTopic = response.readBoolean();
        boolean readTopic = response.readBoolean();
        boolean pollMessages = response.readBoolean();
        boolean sendMessages = response.readBoolean();
        return new TopicPermissions(manageTopic, readTopic, pollMessages, sendMessages);
    }

    static GlobalPermissions readGlobalPermissions(ByteBuf response) {
        boolean manageServers = response.readBoolean();
        boolean readServers = response.readBoolean();
        boolean manageUsers = response.readBoolean();
        boolean readUsers = response.readBoolean();
        boolean manageStreams = response.readBoolean();
        boolean readStreams = response.readBoolean();
        boolean manageTopics = response.readBoolean();
        boolean readTopics = response.readBoolean();
        boolean pollMessages = response.readBoolean();
        boolean sendMessages = response.readBoolean();
        return new GlobalPermissions(manageServers, readServers, manageUsers, readUsers, manageStreams, readStreams, manageTopics, readTopics, pollMessages, sendMessages);
    }

    static UserInfo readUserInfo(ByteBuf response) {
        long userId = response.readUnsignedIntLE();
        BigInteger createdAt = BytesDeserializer.readU64AsBigInteger(response);
        byte statusCode = response.readByte();
        UserStatus status = UserStatus.fromCode(statusCode);
        byte usernameLength = response.readByte();
        String username = response.readCharSequence((int)usernameLength, StandardCharsets.UTF_8).toString();
        return new UserInfo(userId, createdAt, status, username);
    }

    static RawPersonalAccessToken readRawPersonalAccessToken(ByteBuf response) {
        byte tokenLength = response.readByte();
        String token = response.readCharSequence((int)tokenLength, StandardCharsets.UTF_8).toString();
        return new RawPersonalAccessToken(token);
    }

    static PersonalAccessTokenInfo readPersonalAccessTokenInfo(ByteBuf response) {
        byte nameLength = response.readByte();
        String name = response.readCharSequence((int)nameLength, StandardCharsets.UTF_8).toString();
        BigInteger expiry = BytesDeserializer.readU64AsBigInteger(response);
        Optional<BigInteger> expiryOptional = expiry.equals(BigInteger.ZERO) ? Optional.empty() : Optional.of(expiry);
        return new PersonalAccessTokenInfo(name, expiryOptional);
    }

    private static BigInteger readU64AsBigInteger(ByteBuf buffer) {
        byte[] bytesArray = new byte[9];
        buffer.readBytes(bytesArray, 0, 8);
        ArrayUtils.reverse((byte[])bytesArray);
        return new BigInteger(bytesArray);
    }

    private static BytesMessageId readBytesMessageId(ByteBuf buffer) {
        byte[] bytesArray = new byte[16];
        buffer.readBytes(bytesArray);
        ArrayUtils.reverse((byte[])bytesArray);
        return new BytesMessageId(bytesArray);
    }

    private static int toInt(Long size) {
        return size.intValue();
    }

    private static byte[] newByteArray(Long size) {
        return new byte[size.intValue()];
    }
}

