/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import rs.iggy.clients.blocking.ConsumerGroupsClient;
import rs.iggy.clients.blocking.tcp.BytesDeserializer;
import rs.iggy.clients.blocking.tcp.BytesSerializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.consumergroup.ConsumerGroup;
import rs.iggy.consumergroup.ConsumerGroupDetails;
import rs.iggy.identifier.ConsumerId;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;

class ConsumerGroupsTcpClient
implements ConsumerGroupsClient {
    private static final int GET_CONSUMER_GROUP_CODE = 600;
    private static final int GET_CONSUMER_GROUPS_CODE = 601;
    private static final int CREATE_CONSUMER_GROUP_CODE = 602;
    private static final int DELETE_CONSUMER_GROUP_CODE = 603;
    private static final int JOIN_CONSUMER_GROUP_CODE = 604;
    private static final int LEAVE_CONSUMER_GROUP_CODE = 605;
    private final TcpConnectionHandler connection;

    public ConsumerGroupsTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public Optional<ConsumerGroupDetails> getConsumerGroup(StreamId streamId, TopicId topicId, ConsumerId groupId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeBytes(BytesSerializer.toBytes(groupId));
        ByteBuf response = this.connection.send(600, payload);
        if (response.isReadable()) {
            return Optional.of(BytesDeserializer.readConsumerGroupDetails(response));
        }
        return Optional.empty();
    }

    @Override
    public List<ConsumerGroup> getConsumerGroups(StreamId streamId, TopicId topicId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        ByteBuf response = this.connection.send(601, payload);
        ArrayList<ConsumerGroup> groups = new ArrayList<ConsumerGroup>();
        while (response.isReadable()) {
            groups.add(BytesDeserializer.readConsumerGroup(response));
        }
        return groups;
    }

    @Override
    public ConsumerGroupDetails createConsumerGroup(StreamId streamId, TopicId topicId, Optional<Long> groupId, String name) {
        ByteBuf streamIdBytes = BytesSerializer.toBytes(streamId);
        ByteBuf topicIdBytes = BytesSerializer.toBytes(topicId);
        ByteBuf payload = Unpooled.buffer((int)(5 + streamIdBytes.readableBytes() + topicIdBytes.readableBytes() + name.length()));
        payload.writeBytes(streamIdBytes);
        payload.writeBytes(topicIdBytes);
        payload.writeIntLE(groupId.orElse(0L).intValue());
        payload.writeBytes(BytesSerializer.nameToBytes(name));
        ByteBuf response = this.connection.send(602, payload);
        return BytesDeserializer.readConsumerGroupDetails(response);
    }

    @Override
    public void deleteConsumerGroup(StreamId streamId, TopicId topicId, ConsumerId groupId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeBytes(BytesSerializer.toBytes(groupId));
        this.connection.send(603, payload);
    }

    @Override
    public void joinConsumerGroup(StreamId streamId, TopicId topicId, ConsumerId groupId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeBytes(BytesSerializer.toBytes(groupId));
        this.connection.send(604, payload);
    }

    @Override
    public void leaveConsumerGroup(StreamId streamId, TopicId topicId, ConsumerId groupId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeBytes(BytesSerializer.toBytes(groupId));
        this.connection.send(605, payload);
    }
}

