/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.Optional;
import rs.iggy.clients.blocking.ConsumerOffsetsClient;
import rs.iggy.clients.blocking.tcp.BytesDeserializer;
import rs.iggy.clients.blocking.tcp.BytesSerializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.consumergroup.Consumer;
import rs.iggy.consumeroffset.ConsumerOffsetInfo;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;

class ConsumerOffsetTcpClient
implements ConsumerOffsetsClient {
    private static final int GET_CONSUMER_OFFSET_CODE = 120;
    private static final int STORE_CONSUMER_OFFSET_CODE = 121;
    private final TcpConnectionHandler connection;

    public ConsumerOffsetTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public void storeConsumerOffset(StreamId streamId, TopicId topicId, Optional<Long> partitionId, Consumer consumer, BigInteger offset) {
        ByteBuf payload = BytesSerializer.toBytes(consumer);
        payload.writeBytes(BytesSerializer.toBytes(streamId));
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeIntLE(partitionId.orElse(0L).intValue());
        payload.writeBytes(BytesSerializer.toBytesAsU64(offset));
        this.connection.send(121, payload);
    }

    @Override
    public Optional<ConsumerOffsetInfo> getConsumerOffset(StreamId streamId, TopicId topicId, Optional<Long> partitionId, Consumer consumer) {
        ByteBuf payload = BytesSerializer.toBytes(consumer);
        payload.writeBytes(BytesSerializer.toBytes(streamId));
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeIntLE(partitionId.orElse(0L).intValue());
        ByteBuf response = this.connection.send(120, payload);
        if (response.isReadable()) {
            return Optional.of(BytesDeserializer.readConsumerOffsetInfo(response));
        }
        return Optional.empty();
    }
}

