/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import rs.iggy.clients.blocking.ConsumerGroupsClient;
import rs.iggy.clients.blocking.ConsumerOffsetsClient;
import rs.iggy.clients.blocking.IggyClient;
import rs.iggy.clients.blocking.MessagesClient;
import rs.iggy.clients.blocking.PartitionsClient;
import rs.iggy.clients.blocking.PersonalAccessTokensClient;
import rs.iggy.clients.blocking.StreamsClient;
import rs.iggy.clients.blocking.SystemClient;
import rs.iggy.clients.blocking.TopicsClient;
import rs.iggy.clients.blocking.UsersClient;
import rs.iggy.clients.blocking.tcp.ConsumerGroupsTcpClient;
import rs.iggy.clients.blocking.tcp.ConsumerOffsetTcpClient;
import rs.iggy.clients.blocking.tcp.MessagesTcpClient;
import rs.iggy.clients.blocking.tcp.PartitionsTcpClient;
import rs.iggy.clients.blocking.tcp.PersonalAccessTokensTcpClient;
import rs.iggy.clients.blocking.tcp.StreamsTcpClient;
import rs.iggy.clients.blocking.tcp.SystemTcpClient;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.clients.blocking.tcp.TopicsTcpClient;
import rs.iggy.clients.blocking.tcp.UsersTcpClient;

public class IggyTcpClient
implements IggyClient {
    private final UsersTcpClient usersClient;
    private final StreamsTcpClient streamsClient;
    private final TopicsTcpClient topicsClient;
    private final PartitionsTcpClient partitionsClient;
    private final ConsumerGroupsTcpClient consumerGroupsClient;
    private final ConsumerOffsetTcpClient consumerOffsetsClient;
    private final MessagesTcpClient messagesClient;
    private final SystemTcpClient systemClient;
    private final PersonalAccessTokensTcpClient personalAccessTokensClient;

    public IggyTcpClient(String host, Integer port) {
        TcpConnectionHandler connection = new TcpConnectionHandler(host, port);
        this.usersClient = new UsersTcpClient(connection);
        this.streamsClient = new StreamsTcpClient(connection);
        this.topicsClient = new TopicsTcpClient(connection);
        this.partitionsClient = new PartitionsTcpClient(connection);
        this.consumerGroupsClient = new ConsumerGroupsTcpClient(connection);
        this.consumerOffsetsClient = new ConsumerOffsetTcpClient(connection);
        this.messagesClient = new MessagesTcpClient(connection);
        this.systemClient = new SystemTcpClient(connection);
        this.personalAccessTokensClient = new PersonalAccessTokensTcpClient(connection);
    }

    @Override
    public SystemClient system() {
        return this.systemClient;
    }

    @Override
    public StreamsClient streams() {
        return this.streamsClient;
    }

    @Override
    public UsersClient users() {
        return this.usersClient;
    }

    @Override
    public TopicsClient topics() {
        return this.topicsClient;
    }

    @Override
    public PartitionsClient partitions() {
        return this.partitionsClient;
    }

    @Override
    public ConsumerGroupsClient consumerGroups() {
        return this.consumerGroupsClient;
    }

    @Override
    public ConsumerOffsetsClient consumerOffsets() {
        return this.consumerOffsetsClient;
    }

    @Override
    public MessagesClient messages() {
        return this.messagesClient;
    }

    @Override
    public PersonalAccessTokensClient personalAccessTokens() {
        return this.personalAccessTokensClient;
    }
}

