/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import rs.iggy.clients.blocking.MessagesClient;
import rs.iggy.clients.blocking.tcp.BytesDeserializer;
import rs.iggy.clients.blocking.tcp.BytesSerializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.consumergroup.Consumer;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;
import rs.iggy.message.MessageToSend;
import rs.iggy.message.Partitioning;
import rs.iggy.message.PolledMessages;
import rs.iggy.message.PollingStrategy;

class MessagesTcpClient
implements MessagesClient {
    private static final int POLL_MESSAGES_CODE = 100;
    private static final int SEND_MESSAGES_CODE = 101;
    private final TcpConnectionHandler connection;

    public MessagesTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public PolledMessages pollMessages(StreamId streamId, TopicId topicId, Optional<Long> partitionId, Consumer consumer, PollingStrategy strategy, Long count, boolean autoCommit) {
        ByteBuf payload = BytesSerializer.toBytes(consumer);
        payload.writeBytes(BytesSerializer.toBytes(streamId));
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeIntLE(partitionId.orElse(0L).intValue());
        payload.writeBytes(BytesSerializer.toBytes(strategy));
        payload.writeIntLE(count.intValue());
        payload.writeByte(autoCommit ? 1 : 0);
        ByteBuf response = this.connection.send(100, payload);
        return BytesDeserializer.readPolledMessages(response);
    }

    @Override
    public void sendMessages(StreamId streamId, TopicId topicId, Partitioning partitioning, List<MessageToSend> messages) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeBytes(BytesSerializer.toBytes(partitioning));
        for (MessageToSend message : messages) {
            payload.writeBytes(BytesSerializer.toBytes(message));
        }
        this.connection.send(101, payload);
    }
}

