/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import rs.iggy.clients.blocking.PartitionsClient;
import rs.iggy.clients.blocking.tcp.BytesSerializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;

class PartitionsTcpClient
implements PartitionsClient {
    private static final int CREATE_PARTITION_CODE = 402;
    private static final int DELETE_PARTITION_CODE = 403;
    private final TcpConnectionHandler connection;

    PartitionsTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public void createPartitions(StreamId streamId, TopicId topicId, Long partitionsCount) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeIntLE(partitionsCount.intValue());
        this.connection.send(402, payload);
    }

    @Override
    public void deletePartitions(StreamId streamId, TopicId topicId, Long partitionsCount) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeIntLE(partitionsCount.intValue());
        this.connection.send(403, payload);
    }
}

