/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import rs.iggy.clients.blocking.PersonalAccessTokensClient;
import rs.iggy.clients.blocking.tcp.BytesDeserializer;
import rs.iggy.clients.blocking.tcp.BytesSerializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.personalaccesstoken.PersonalAccessTokenInfo;
import rs.iggy.personalaccesstoken.RawPersonalAccessToken;
import rs.iggy.user.IdentityInfo;

class PersonalAccessTokensTcpClient
implements PersonalAccessTokensClient {
    private static final int GET_PERSONAL_ACCESS_TOKENS_CODE = 41;
    private static final int CREATE_PERSONAL_ACCESS_TOKEN_CODE = 42;
    private static final int DELETE_PERSONAL_ACCESS_TOKEN_CODE = 43;
    private static final int LOGIN_WITH_PERSONAL_ACCESS_TOKEN_CODE = 44;
    private final TcpConnectionHandler connection;

    public PersonalAccessTokensTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public RawPersonalAccessToken createPersonalAccessToken(String name, BigInteger expiry) {
        ByteBuf payload = Unpooled.buffer();
        payload.writeBytes(BytesSerializer.nameToBytes(name));
        payload.writeBytes(BytesSerializer.toBytesAsU64(expiry));
        ByteBuf response = this.connection.send(42, payload);
        return BytesDeserializer.readRawPersonalAccessToken(response);
    }

    @Override
    public List<PersonalAccessTokenInfo> getPersonalAccessTokens() {
        ByteBuf response = this.connection.send(41);
        ArrayList<PersonalAccessTokenInfo> tokens = new ArrayList<PersonalAccessTokenInfo>();
        while (response.isReadable()) {
            tokens.add(BytesDeserializer.readPersonalAccessTokenInfo(response));
        }
        return tokens;
    }

    @Override
    public void deletePersonalAccessToken(String name) {
        ByteBuf payload = BytesSerializer.nameToBytes(name);
        this.connection.send(43, payload);
    }

    @Override
    public IdentityInfo loginWithPersonalAccessToken(String token) {
        ByteBuf payload = BytesSerializer.nameToBytes(token);
        ByteBuf response = this.connection.send(44, payload);
        long userId = response.readUnsignedIntLE();
        return new IdentityInfo(userId, Optional.empty());
    }
}

