/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import rs.iggy.clients.blocking.StreamsClient;
import rs.iggy.clients.blocking.tcp.BytesDeserializer;
import rs.iggy.clients.blocking.tcp.BytesSerializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.identifier.StreamId;
import rs.iggy.stream.StreamBase;
import rs.iggy.stream.StreamDetails;

class StreamsTcpClient
implements StreamsClient {
    private static final int GET_STREAM_CODE = 200;
    private static final int GET_STREAMS_CODE = 201;
    private static final int CREATE_STREAM_CODE = 202;
    private static final int DELETE_STREAM_CODE = 203;
    private static final int UPDATE_STREAM_CODE = 204;
    private final TcpConnectionHandler connection;

    StreamsTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public StreamDetails createStream(Optional<Long> streamId, String name) {
        int payloadSize = 5 + name.length();
        ByteBuf payload = Unpooled.buffer((int)payloadSize);
        payload.writeIntLE(streamId.orElse(0L).intValue());
        payload.writeBytes(BytesSerializer.nameToBytes(name));
        ByteBuf response = this.connection.send(202, payload);
        return BytesDeserializer.readStreamDetails(response);
    }

    @Override
    public Optional<StreamDetails> getStream(StreamId streamId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        ByteBuf response = this.connection.send(200, payload);
        if (response.isReadable()) {
            return Optional.of(BytesDeserializer.readStreamDetails(response));
        }
        return Optional.empty();
    }

    @Override
    public List<StreamBase> getStreams() {
        ByteBuf response = this.connection.send(201);
        ArrayList<StreamBase> streams = new ArrayList<StreamBase>();
        while (response.isReadable()) {
            streams.add(BytesDeserializer.readStreamBase(response));
        }
        return streams;
    }

    @Override
    public void updateStream(StreamId streamId, String name) {
        int payloadSize = 1 + name.length();
        ByteBuf idBytes = BytesSerializer.toBytes(streamId);
        ByteBuf payload = Unpooled.buffer((int)(payloadSize + idBytes.capacity()));
        payload.writeBytes(idBytes);
        payload.writeBytes(BytesSerializer.nameToBytes(name));
        this.connection.send(204, payload);
    }

    @Override
    public void deleteStream(StreamId streamId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        this.connection.send(203, payload);
    }
}

