/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import rs.iggy.clients.blocking.SystemClient;
import rs.iggy.clients.blocking.tcp.BytesDeserializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.system.ClientInfo;
import rs.iggy.system.ClientInfoDetails;
import rs.iggy.system.Stats;

class SystemTcpClient
implements SystemClient {
    private static final int PING_CODE = 1;
    private static final int GET_STATS_CODE = 10;
    private static final int GET_ME_CODE = 20;
    private static final int GET_CLIENT_CODE = 21;
    private static final int GET_CLIENTS_CODE = 22;
    private final TcpConnectionHandler connection;

    SystemTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public Stats getStats() {
        ByteBuf response = this.connection.send(10);
        return BytesDeserializer.readStats(response);
    }

    @Override
    public ClientInfoDetails getMe() {
        ByteBuf response = this.connection.send(20);
        return BytesDeserializer.readClientInfoDetails(response);
    }

    @Override
    public ClientInfoDetails getClient(Long clientId) {
        ByteBuf payload = Unpooled.buffer((int)4);
        payload.writeIntLE(clientId.intValue());
        ByteBuf response = this.connection.send(21, payload);
        return BytesDeserializer.readClientInfoDetails(response);
    }

    @Override
    public List<ClientInfo> getClients() {
        ByteBuf response = this.connection.send(22);
        ArrayList<ClientInfo> clients = new ArrayList<ClientInfo>();
        while (response.isReadable()) {
            clients.add(BytesDeserializer.readClientInfo(response));
        }
        return clients;
    }

    @Override
    public String ping() {
        this.connection.send(1);
        return "";
    }
}

