/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;

final class TcpConnectionHandler {
    private static final int REQUEST_INITIAL_BYTES_LENGTH = 4;
    private static final int COMMAND_LENGTH = 4;
    private static final int RESPONSE_INITIAL_BYTES_LENGTH = 8;
    private final Connection connection;
    private final BlockingQueue<IggyResponse> responses = new LinkedBlockingQueue<IggyResponse>();

    TcpConnectionHandler(String host, Integer port) {
        this.connection = TcpClient.create().host(host).port(port.intValue()).doOnConnected(conn -> conn.addHandlerLast((ChannelHandler)new IggyResponseDecoder())).connectNow();
        this.connection.inbound().receiveObject().ofType(IggyResponse.class).subscribe(this.responses::add);
    }

    ByteBuf send(int command) {
        return this.send(command, Unpooled.EMPTY_BUFFER);
    }

    ByteBuf send(int command, ByteBuf payload) {
        int payloadSize = payload.readableBytes() + 4;
        ByteBuf buffer = Unpooled.buffer((int)(4 + payloadSize));
        buffer.writeIntLE(payloadSize);
        buffer.writeIntLE(command);
        buffer.writeBytes(payload);
        this.connection.outbound().send((Publisher)Mono.just((Object)buffer)).then().block();
        try {
            IggyResponse response = this.responses.take();
            return this.handleResponse(response);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private ByteBuf handleResponse(IggyResponse response) {
        if (response.status() != 0L) {
            throw new RuntimeException("Received an invalid response with status " + response.status());
        }
        if (response.length() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return response.payload();
    }

    record IggyResponse(long status, int length, ByteBuf payload) {
    }

    static class IggyResponseDecoder
    extends ByteToMessageDecoder {
        IggyResponseDecoder() {
        }

        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            if (byteBuf.readableBytes() < 8) {
                return;
            }
            byteBuf.markReaderIndex();
            long status = byteBuf.readUnsignedIntLE();
            long responseLength = byteBuf.readUnsignedIntLE();
            if ((long)byteBuf.readableBytes() < responseLength) {
                byteBuf.resetReaderIndex();
                return;
            }
            int length = Long.valueOf(responseLength).intValue();
            list.add(new IggyResponse(status, length, byteBuf.readBytes(length)));
        }
    }
}

