/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import rs.iggy.clients.blocking.TopicsClient;
import rs.iggy.clients.blocking.tcp.BytesDeserializer;
import rs.iggy.clients.blocking.tcp.BytesSerializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.identifier.StreamId;
import rs.iggy.identifier.TopicId;
import rs.iggy.topic.CompressionAlgorithm;
import rs.iggy.topic.Topic;
import rs.iggy.topic.TopicDetails;

class TopicsTcpClient
implements TopicsClient {
    private static final int GET_TOPIC_CODE = 300;
    private static final int GET_TOPICS_CODE = 301;
    private static final int CREATE_TOPIC_CODE = 302;
    private static final int DELETE_TOPIC_CODE = 303;
    private static final int UPDATE_TOPIC_CODE = 304;
    private static final int PURGE_TOPIC_CODE = 305;
    private final TcpConnectionHandler connection;

    TopicsTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public Optional<TopicDetails> getTopic(StreamId streamId, TopicId topicId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        ByteBuf response = this.connection.send(300, payload);
        if (response.isReadable()) {
            return Optional.of(BytesDeserializer.readTopicDetails(response));
        }
        return Optional.empty();
    }

    @Override
    public List<Topic> getTopics(StreamId streamId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        ByteBuf response = this.connection.send(301, payload);
        ArrayList<Topic> topics = new ArrayList<Topic>();
        while (response.isReadable()) {
            topics.add(BytesDeserializer.readTopic(response));
        }
        return topics;
    }

    @Override
    public TopicDetails createTopic(StreamId streamId, Optional<Long> topicId, Long partitionsCount, CompressionAlgorithm compressionAlgorithm, BigInteger messageExpiry, BigInteger maxTopicSize, Optional<Short> replicationFactor, String name) {
        ByteBuf streamIdBytes = BytesSerializer.toBytes(streamId);
        ByteBuf payload = Unpooled.buffer((int)(27 + streamIdBytes.readableBytes() + name.length()));
        payload.writeBytes(streamIdBytes);
        payload.writeIntLE(topicId.orElse(0L).intValue());
        payload.writeIntLE(partitionsCount.intValue());
        payload.writeByte(compressionAlgorithm.asCode().intValue());
        payload.writeBytes(BytesSerializer.toBytesAsU64(messageExpiry));
        payload.writeBytes(BytesSerializer.toBytesAsU64(maxTopicSize));
        payload.writeByte((int)replicationFactor.orElse((short)0).shortValue());
        payload.writeBytes(BytesSerializer.nameToBytes(name));
        ByteBuf response = this.connection.send(302, payload);
        return BytesDeserializer.readTopicDetails(response);
    }

    @Override
    public void updateTopic(StreamId streamId, TopicId topicId, CompressionAlgorithm compressionAlgorithm, BigInteger messageExpiry, BigInteger maxTopicSize, Optional<Short> replicationFactor, String name) {
        ByteBuf payload = Unpooled.buffer();
        payload.writeBytes(BytesSerializer.toBytes(streamId));
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        payload.writeByte(compressionAlgorithm.asCode().intValue());
        payload.writeBytes(BytesSerializer.toBytesAsU64(messageExpiry));
        payload.writeBytes(BytesSerializer.toBytesAsU64(maxTopicSize));
        payload.writeByte((int)replicationFactor.orElse((short)0).shortValue());
        payload.writeBytes(BytesSerializer.nameToBytes(name));
        this.connection.send(304, payload);
    }

    @Override
    public void deleteTopic(StreamId streamId, TopicId topicId) {
        ByteBuf payload = BytesSerializer.toBytes(streamId);
        payload.writeBytes(BytesSerializer.toBytes(topicId));
        this.connection.send(303, payload);
    }
}

