/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.clients.blocking.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import rs.iggy.clients.blocking.UsersClient;
import rs.iggy.clients.blocking.tcp.BytesDeserializer;
import rs.iggy.clients.blocking.tcp.BytesSerializer;
import rs.iggy.clients.blocking.tcp.TcpConnectionHandler;
import rs.iggy.identifier.UserId;
import rs.iggy.user.IdentityInfo;
import rs.iggy.user.Permissions;
import rs.iggy.user.UserInfo;
import rs.iggy.user.UserInfoDetails;
import rs.iggy.user.UserStatus;

class UsersTcpClient
implements UsersClient {
    private static final int GET_USER_CODE = 31;
    private static final int GET_USERS_CODE = 32;
    private static final int CREATE_USER_CODE = 33;
    private static final int DELETE_USER_CODE = 34;
    private static final int UPDATE_USER_CODE = 35;
    private static final int UPDATE_PERMISSIONS_CODE = 36;
    private static final int CHANGE_PASSWORD_CODE = 37;
    private static final int LOGIN_USER_CODE = 38;
    private static final int LOGOUT_USER_CODE = 39;
    private final TcpConnectionHandler connection;

    UsersTcpClient(TcpConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public Optional<UserInfoDetails> getUser(UserId userId) {
        ByteBuf payload = BytesSerializer.toBytes(userId);
        ByteBuf response = this.connection.send(31, payload);
        if (response.isReadable()) {
            return Optional.of(BytesDeserializer.readUserInfoDetails(response));
        }
        return Optional.empty();
    }

    @Override
    public List<UserInfo> getUsers() {
        ByteBuf response = this.connection.send(32);
        ArrayList<UserInfo> users = new ArrayList<UserInfo>();
        while (response.isReadable()) {
            users.add(BytesDeserializer.readUserInfo(response));
        }
        return users;
    }

    @Override
    public UserInfoDetails createUser(String username, String password, UserStatus status, Optional<Permissions> permissions) {
        ByteBuf payload = Unpooled.buffer();
        payload.writeBytes(BytesSerializer.nameToBytes(username));
        payload.writeBytes(BytesSerializer.nameToBytes(password));
        payload.writeByte(status.asCode());
        permissions.ifPresentOrElse(perms -> {
            payload.writeByte(1);
            ByteBuf permissionBytes = BytesSerializer.toBytes(perms);
            payload.writeIntLE(permissionBytes.readableBytes());
            payload.writeBytes(permissionBytes);
        }, () -> payload.writeByte(0));
        ByteBuf response = this.connection.send(33, payload);
        return BytesDeserializer.readUserInfoDetails(response);
    }

    @Override
    public void deleteUser(UserId userId) {
        ByteBuf payload = BytesSerializer.toBytes(userId);
        this.connection.send(34, payload);
    }

    @Override
    public void updateUser(UserId userId, Optional<String> usernameOptional, Optional<UserStatus> statusOptional) {
        ByteBuf payload = BytesSerializer.toBytes(userId);
        usernameOptional.ifPresentOrElse(username -> {
            payload.writeByte(1);
            payload.writeBytes(BytesSerializer.nameToBytes(username));
        }, () -> payload.writeByte(0));
        statusOptional.ifPresentOrElse(status -> {
            payload.writeByte(1);
            payload.writeByte(status.asCode());
        }, () -> payload.writeByte(0));
        this.connection.send(35, payload);
    }

    @Override
    public void updatePermissions(UserId userId, Optional<Permissions> permissionsOptional) {
        ByteBuf payload = BytesSerializer.toBytes(userId);
        permissionsOptional.ifPresentOrElse(permissions -> {
            payload.writeByte(1);
            ByteBuf permissionBytes = BytesSerializer.toBytes(permissions);
            payload.writeIntLE(permissionBytes.readableBytes());
            payload.writeBytes(permissionBytes);
        }, () -> payload.writeByte(0));
        this.connection.send(36, payload);
    }

    @Override
    public void changePassword(UserId userId, String currentPassword, String newPassword) {
        ByteBuf payload = BytesSerializer.toBytes(userId);
        payload.writeBytes(BytesSerializer.nameToBytes(currentPassword));
        payload.writeBytes(BytesSerializer.nameToBytes(newPassword));
        this.connection.send(37, payload);
    }

    @Override
    public IdentityInfo login(String username, String password) {
        String version = "0.0.1";
        String context = "java-sdk";
        int payloadSize = 2 + username.length() + password.length() + 4 + version.length() + 4 + context.length();
        ByteBuf payload = Unpooled.buffer((int)payloadSize);
        payload.writeBytes(BytesSerializer.nameToBytes(username));
        payload.writeBytes(BytesSerializer.nameToBytes(password));
        payload.writeIntLE(version.length());
        payload.writeBytes(version.getBytes());
        payload.writeIntLE(context.length());
        payload.writeBytes(context.getBytes());
        ByteBuf response = this.connection.send(38, payload);
        long userId = response.readUnsignedIntLE();
        return new IdentityInfo(userId, Optional.empty());
    }

    @Override
    public void logout() {
        this.connection.send(39);
    }
}

