/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.identifier;

import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class Identifier {
    private final String name;
    private final Long id;

    protected Identifier(@Nullable String name, @Nullable Long id) {
        if (StringUtils.isBlank((CharSequence)name) && id == null) {
            throw new IllegalArgumentException("Name and id cannot be blank");
        }
        if (StringUtils.isNotBlank((CharSequence)name) && id != null) {
            throw new IllegalArgumentException("Name and id cannot be both present");
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.name = name;
            this.id = null;
        } else {
            this.name = null;
            this.id = id;
        }
    }

    public String toString() {
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            return this.name;
        }
        return this.id.toString();
    }

    public int getKind() {
        if (this.id != null) {
            return 1;
        }
        return 2;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

