/*
 * Decompiled with CFR 0.152.
 */
package rs.iggy.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.UUID;
import rs.iggy.message.MessageId;

public class UuidMessageId
implements MessageId {
    private final UUID value;

    public UuidMessageId(UUID value) {
        this.value = value;
    }

    @Override
    public BigInteger toBigInteger() {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(this.value.getMostSignificantBits());
        buffer.putLong(this.value.getLeastSignificantBits());
        return new BigInteger(1, buffer.array());
    }

    @Override
    public ByteBuf toBytes() {
        ByteBuf buffer = Unpooled.buffer((int)16, (int)16);
        buffer.writeLongLE(this.value.getLeastSignificantBits());
        buffer.writeLongLE(this.value.getMostSignificantBits());
        return buffer;
    }

    public String toString() {
        return this.value.toString();
    }
}

