/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import rs.ltt.jmap.client.JmapRequest;
import rs.ltt.jmap.client.MethodResponses;
import rs.ltt.jmap.client.api.JmapApiClient;
import rs.ltt.jmap.client.api.JmapApiClientFactory;
import rs.ltt.jmap.client.api.SessionStateListener;
import rs.ltt.jmap.client.blob.BinaryDataClient;
import rs.ltt.jmap.client.blob.Download;
import rs.ltt.jmap.client.blob.MaxUploadSizeExceededException;
import rs.ltt.jmap.client.blob.Progress;
import rs.ltt.jmap.client.blob.Uploadable;
import rs.ltt.jmap.client.event.EventSourcePushService;
import rs.ltt.jmap.client.event.OnStateChangeListener;
import rs.ltt.jmap.client.event.PushService;
import rs.ltt.jmap.client.http.BasicAuthHttpAuthentication;
import rs.ltt.jmap.client.http.HttpAuthentication;
import rs.ltt.jmap.client.session.Session;
import rs.ltt.jmap.client.session.SessionCache;
import rs.ltt.jmap.client.session.SessionClient;
import rs.ltt.jmap.client.util.Closeables;
import rs.ltt.jmap.common.entity.Downloadable;
import rs.ltt.jmap.common.entity.Upload;
import rs.ltt.jmap.common.entity.capability.CoreCapability;
import rs.ltt.jmap.common.method.MethodCall;

public class JmapClient
implements Closeable {
    private final SessionClient sessionClient;
    private final BinaryDataClient binaryDataClient;
    private final HttpAuthentication authentication;
    private final SessionStateListener sessionStateListener = new SessionStateListener(){

        @Override
        public void onSessionStateRetrieved(String sessionState) {
            JmapClient.this.sessionClient.setLatestSessionState(sessionState);
        }
    };
    private JmapApiClient jmapApiClient;
    private boolean useWebSocket = false;

    public JmapClient(String username, String password) {
        this(new BasicAuthHttpAuthentication(username, password));
    }

    public JmapClient(HttpAuthentication httpAuthentication) {
        this.authentication = httpAuthentication;
        this.sessionClient = new SessionClient(httpAuthentication);
        this.binaryDataClient = new BinaryDataClient(httpAuthentication);
    }

    public JmapClient(String username, String password, HttpUrl base) {
        this(new BasicAuthHttpAuthentication(username, password), base);
    }

    public JmapClient(HttpAuthentication httpAuthentication, HttpUrl sessionResource) {
        this.authentication = httpAuthentication;
        this.sessionClient = new SessionClient(httpAuthentication, sessionResource);
        this.binaryDataClient = new BinaryDataClient(httpAuthentication);
    }

    public String getUsername() {
        return this.authentication.getUsername();
    }

    public ListenableFuture<MethodResponses> call(MethodCall methodCall) {
        JmapRequest.Builder jmapRequestBuilder = new JmapRequest.Builder();
        ListenableFuture<MethodResponses> methodResponsesFuture = jmapRequestBuilder.call(methodCall).getMethodResponses();
        this.execute(jmapRequestBuilder.build());
        return methodResponsesFuture;
    }

    private void execute(final JmapRequest request) {
        ListenableFuture<Session> sessionFuture = this.getSession();
        request.addDependentFuture((Future<?>)sessionFuture);
        Futures.addCallback(sessionFuture, (FutureCallback)new FutureCallback<Session>(){

            public void onSuccess(@Nullable Session session) {
                JmapClient.this.execute(request, session);
            }

            public void onFailure(@Nonnull Throwable throwable) {
                request.setException(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void execute(JmapRequest request, Session session) {
        try {
            Preconditions.checkState((session != null ? 1 : 0) != 0, (Object)"Session was null");
            JmapApiClient apiClient = this.getApiClient(session);
            apiClient.execute(request);
        }
        catch (Throwable throwable) {
            request.setException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JmapApiClient getApiClient(Session session) {
        JmapApiClient current = this.jmapApiClient;
        if (current != null && current.isValidFor(session)) {
            return current;
        }
        JmapClient jmapClient = this;
        synchronized (jmapClient) {
            if (this.jmapApiClient != null && this.jmapApiClient.isValidFor(session)) {
                return this.jmapApiClient;
            }
            JmapApiClientFactory factory = new JmapApiClientFactory(this.authentication, this.sessionStateListener);
            this.jmapApiClient = factory.getJmapApiClient(session, this.useWebSocket);
            return this.jmapApiClient;
        }
    }

    public ListenableFuture<Session> getSession() {
        return this.sessionClient.get();
    }

    public ListenableFuture<PushService> monitorEvents() {
        return this.monitorEvents(null);
    }

    public ListenableFuture<PushService> monitorEvents(@Nullable OnStateChangeListener onStateChangeListener) {
        return Futures.transform(this.getSession(), session -> this.monitorEvents((Session)session, onStateChangeListener), (Executor)MoreExecutors.directExecutor());
    }

    private PushService monitorEvents(Session session, @Nullable OnStateChangeListener onStateChangeListener) {
        JmapApiClient jmapApiClient = this.getApiClient(session);
        PushService pushService = jmapApiClient instanceof PushService ? (PushService)((Object)jmapApiClient) : new EventSourcePushService(session, this.authentication);
        if (onStateChangeListener != null) {
            pushService.addOnStateChangeListener(onStateChangeListener);
        }
        return pushService;
    }

    public MultiCall newMultiCall() {
        return new MultiCall();
    }

    public void setSessionCache(SessionCache sessionCache) {
        this.sessionClient.setSessionCache(sessionCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseWebSocket(boolean useWebSocket) {
        JmapClient jmapClient = this;
        synchronized (jmapClient) {
            Preconditions.checkState((this.jmapApiClient == null ? 1 : 0) != 0, (Object)"WebSocket preference needs to be set before making the first API call");
        }
        this.useWebSocket = useWebSocket;
    }

    public ListenableFuture<Download> download(String accountId, Downloadable downloadable) {
        return Futures.transformAsync(this.getSession(), session -> this.download((Session)session, accountId, downloadable, 0L), (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Download> download(Session session, String accountId, Downloadable downloadable, long rangeStart) {
        HttpUrl httpUrl = session.getDownloadUrl(accountId, downloadable);
        return this.binaryDataClient.download(httpUrl, rangeStart);
    }

    public ListenableFuture<Download> download(String accountId, Downloadable downloadable, long rangeStart) {
        Preconditions.checkArgument((rangeStart >= 0L ? 1 : 0) != 0, (Object)"rangeStart must not be smaller than 0");
        return Futures.transformAsync(this.getSession(), session -> this.download((Session)session, accountId, downloadable, rangeStart), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Upload> upload(@Nonnull String accountId, @Nonnull Uploadable uploadable, Progress progress) {
        Preconditions.checkArgument((accountId != null ? 1 : 0) != 0, (Object)"accountId must not be null");
        Preconditions.checkArgument((uploadable != null ? 1 : 0) != 0, (Object)"Uploadable must not be null");
        return Futures.transformAsync(this.getSession(), session -> this.upload((Session)session, accountId, uploadable, progress), (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Upload> upload(Session session, String accountId, Uploadable uploadable, Progress progress) {
        Long maxUploadSize;
        HttpUrl httpUrl = session.getUploadUrl(accountId);
        CoreCapability coreCapability = session.getCapability(CoreCapability.class);
        Long l = maxUploadSize = coreCapability == null ? null : coreCapability.getMaxSizeUpload();
        if (maxUploadSize != null && uploadable.getContentLength() > maxUploadSize) {
            return Futures.immediateFailedFuture((Throwable)new MaxUploadSizeExceededException(uploadable.getContentLength(), maxUploadSize));
        }
        return this.binaryDataClient.upload(httpUrl, uploadable, progress);
    }

    @Override
    public void close() {
        JmapApiClient apiClient = this.jmapApiClient;
        if (apiClient instanceof Closeable) {
            Closeables.closeQuietly((Closeable)((Object)apiClient));
        }
    }

    public class MultiCall {
        private final JmapRequest.Builder jmapRequestBuilder = new JmapRequest.Builder();
        private boolean executed = false;

        private MultiCall() {
        }

        public synchronized JmapRequest.Call call(MethodCall methodCall) {
            Preconditions.checkState((!this.executed ? 1 : 0) != 0, (Object)"Unable to add MethodCall. MultiCall has already been executed");
            return this.jmapRequestBuilder.call(methodCall);
        }

        public synchronized void execute() {
            Preconditions.checkState((!this.executed ? 1 : 0) != 0, (Object)"You must not execute the same MultiCall twice");
            this.executed = true;
            JmapClient.this.execute(this.jmapRequestBuilder.build());
        }
    }
}

