/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import rs.ltt.jmap.client.MethodResponses;
import rs.ltt.jmap.common.Request;
import rs.ltt.jmap.common.method.MethodCall;

public class JmapRequest {
    private final ImmutableMap<Request.Invocation, SettableFuture<MethodResponses>> invocationFutureImmutableMap;
    private final Request request;
    private final ArrayList<Future<?>> dependentFutures = new ArrayList();

    private JmapRequest(Map<Request.Invocation, SettableFuture<MethodResponses>> map) {
        Request.Builder requestBuilder = new Request.Builder();
        for (Request.Invocation invocation : map.keySet()) {
            requestBuilder.add(invocation);
        }
        this.request = requestBuilder.build();
        this.invocationFutureImmutableMap = ImmutableMap.copyOf(map);
        Futures.whenAllComplete((Iterable)this.invocationFutureImmutableMap.values()).call(() -> {
            if (this.invocationFutureImmutableMap.values().stream().allMatch(future -> future.isCancelled())) {
                this.dependentFutures.forEach((Consumer<Future<?>>)((Consumer<Future>)f -> f.cancel(true)));
            }
            return null;
        }, MoreExecutors.directExecutor());
    }

    public void addDependentFuture(Future<?> future) {
        this.dependentFutures.add(future);
    }

    public ImmutableMap<Request.Invocation, SettableFuture<MethodResponses>> getInvocationFutureImmutableMap() {
        return this.invocationFutureImmutableMap;
    }

    public void setException(Throwable throwable) {
        for (SettableFuture future : this.invocationFutureImmutableMap.values()) {
            future.setException(throwable);
        }
    }

    public Request getRequest() {
        return this.request;
    }

    public static class Call {
        private final ListenableFuture<MethodResponses> future;
        private final Request.Invocation invocation;

        private Call(ListenableFuture<MethodResponses> future, Request.Invocation invocation) {
            this.future = future;
            this.invocation = invocation;
        }

        public ListenableFuture<MethodResponses> getMethodResponses() {
            return this.future;
        }

        public Request.Invocation.ResultReference createResultReference(String path) {
            return this.invocation.createReference(path);
        }
    }

    public static class Builder {
        private final Map<Request.Invocation, SettableFuture<MethodResponses>> map = new LinkedHashMap<Request.Invocation, SettableFuture<MethodResponses>>();
        private int nextMethodCallId = 0;

        public Call call(MethodCall methodCall) {
            Request.Invocation invocation = new Request.Invocation(methodCall, this.nextMethodCallId());
            ListenableFuture<MethodResponses> future = this.add(invocation);
            return new Call(future, invocation);
        }

        private String nextMethodCallId() {
            return Integer.toString(this.nextMethodCallId++);
        }

        private ListenableFuture<MethodResponses> add(Request.Invocation invocation) {
            SettableFuture future = SettableFuture.create();
            this.map.put(invocation, (SettableFuture<MethodResponses>)future);
            return future;
        }

        public JmapRequest build() {
            return new JmapRequest(this.map);
        }
    }
}

