/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.ltt.jmap.client.api.UserAgentInterceptor;
import rs.ltt.jmap.gson.JmapAdapters;

public final class Services {
    public static final Logger OK_HTTP_LOGGER = LoggerFactory.getLogger(OkHttpClient.class);
    public static final OkHttpClient OK_HTTP_CLIENT;
    public static final OkHttpClient OK_HTTP_CLIENT_LOGGING;
    public static final Gson GSON;
    public static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE;

    private Services() {
        throw new IllegalStateException("Do not instantiate this class");
    }

    static {
        SCHEDULED_EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor((Interceptor)new UserAgentInterceptor());
        OK_HTTP_CLIENT = builder.build();
        if (OK_HTTP_LOGGER.isInfoEnabled()) {
            HttpLoggingInterceptor loggingInterceptor;
            OkHttpClient.Builder loggingBuilder = OK_HTTP_CLIENT.newBuilder();
            if (OK_HTTP_LOGGER.isDebugEnabled()) {
                loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)OK_HTTP_LOGGER).debug(arg_0));
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            } else {
                loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)OK_HTTP_LOGGER).info(arg_0));
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            }
            loggingBuilder.addInterceptor((Interceptor)loggingInterceptor);
            OK_HTTP_CLIENT_LOGGING = loggingBuilder.build();
        } else {
            OK_HTTP_CLIENT_LOGGING = OK_HTTP_CLIENT;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        JmapAdapters.register((GsonBuilder)gsonBuilder);
        GSON = gsonBuilder.create();
    }
}

