/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.ltt.jmap.client.JmapRequest;
import rs.ltt.jmap.client.MethodResponses;
import rs.ltt.jmap.client.api.ErrorResponseException;
import rs.ltt.jmap.client.api.JmapApiClient;
import rs.ltt.jmap.client.api.MethodErrorResponseException;
import rs.ltt.jmap.client.api.MethodResponseNotFoundException;
import rs.ltt.jmap.client.api.SessionStateListener;
import rs.ltt.jmap.client.util.ResponseAnalyzer;
import rs.ltt.jmap.common.ErrorResponse;
import rs.ltt.jmap.common.GenericResponse;
import rs.ltt.jmap.common.Request;
import rs.ltt.jmap.common.Response;
import rs.ltt.jmap.common.method.MethodErrorResponse;
import rs.ltt.jmap.common.method.MethodResponse;

public abstract class AbstractJmapApiClient
implements JmapApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJmapApiClient.class);
    private final SessionStateListener sessionStateListener;

    protected AbstractJmapApiClient(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
    }

    protected void processResponse(JmapRequest jmapRequest, GenericResponse genericResponse) {
        if (genericResponse instanceof ErrorResponse) {
            jmapRequest.setException(new ErrorResponseException((ErrorResponse)genericResponse));
        } else if (genericResponse instanceof Response) {
            Response response = (Response)genericResponse;
            ResponseAnalyzer responseAnalyzer = ResponseAnalyzer.analyse(response);
            ImmutableMap<Request.Invocation, SettableFuture<MethodResponses>> map = jmapRequest.getInvocationFutureImmutableMap();
            this.onSessionStateRetrieved(response.getSessionState());
            for (Map.Entry entry : map.entrySet()) {
                Request.Invocation invocation = (Request.Invocation)entry.getKey();
                SettableFuture future = (SettableFuture)entry.getValue();
                MethodResponses methodResponses = responseAnalyzer.find(invocation);
                if (methodResponses == null) {
                    future.setException((Throwable)new MethodResponseNotFoundException(invocation));
                    continue;
                }
                MethodResponse main = methodResponses.getMain();
                if (main instanceof MethodErrorResponse) {
                    future.setException((Throwable)new MethodErrorResponseException((MethodErrorResponse)main, methodResponses.getAdditional(), invocation.getMethodCall()));
                    continue;
                }
                future.set((Object)methodResponses);
            }
        } else {
            throw new IllegalArgumentException(String.format("Unable to process response of type %s", genericResponse.getClass().getName()));
        }
    }

    private void onSessionStateRetrieved(String sessionState) {
        LOGGER.debug("Notified of session state='{}'", (Object)sessionState);
        if (this.sessionStateListener != null) {
            this.sessionStateListener.onSessionStateRetrieved(sessionState);
        }
    }
}

