/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.api;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.ltt.jmap.client.JmapRequest;
import rs.ltt.jmap.client.Services;
import rs.ltt.jmap.client.api.AbstractJmapApiClient;
import rs.ltt.jmap.client.api.EndpointNotFoundException;
import rs.ltt.jmap.client.api.SessionStateListener;
import rs.ltt.jmap.client.api.UnauthorizedException;
import rs.ltt.jmap.client.http.BasicAuthHttpAuthentication;
import rs.ltt.jmap.client.http.HttpAuthentication;
import rs.ltt.jmap.client.session.Session;
import rs.ltt.jmap.client.util.SettableCallFuture;
import rs.ltt.jmap.common.GenericResponse;

public class HttpJmapApiClient
extends AbstractJmapApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpJmapApiClient.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.get((String)"application/json");
    private final HttpUrl apiUrl;
    private final HttpAuthentication httpAuthentication;

    public HttpJmapApiClient(HttpUrl apiUrl, String username, String password) {
        this(apiUrl, new BasicAuthHttpAuthentication(username, password), null);
    }

    public HttpJmapApiClient(HttpUrl apiUrl, HttpAuthentication httpAuthentication, @Nullable SessionStateListener sessionStateListener) {
        super(sessionStateListener);
        this.apiUrl = (HttpUrl)Preconditions.checkNotNull((Object)apiUrl, (Object)"This API URL must not be null");
        this.httpAuthentication = httpAuthentication;
    }

    public HttpJmapApiClient(HttpUrl apiUrl, HttpAuthentication httpAuthentication) {
        this(apiUrl, httpAuthentication, null);
    }

    @Override
    public void execute(final JmapRequest jmapRequest) {
        String json;
        try {
            json = Services.GSON.toJson((Object)jmapRequest.getRequest());
        }
        catch (Throwable throwable) {
            jmapRequest.setException(throwable);
            return;
        }
        ListenableFuture<InputStream> inputStreamFuture = this.send(json);
        jmapRequest.addDependentFuture((Future<?>)inputStreamFuture);
        Futures.addCallback(inputStreamFuture, (FutureCallback)new FutureCallback<InputStream>(){

            public void onSuccess(InputStream inputStream) {
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    GenericResponse genericResponse = (GenericResponse)Services.GSON.fromJson((Reader)reader, GenericResponse.class);
                    HttpJmapApiClient.this.processResponse(jmapRequest, genericResponse);
                }
                catch (Exception e) {
                    jmapRequest.setException(e);
                }
            }

            public void onFailure(@Nonnull Throwable throwable) {
                jmapRequest.setException(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<InputStream> send(String out) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(this.apiUrl);
        this.httpAuthentication.authenticate(requestBuilder);
        requestBuilder.post(RequestBody.create((String)out, (MediaType)MEDIA_TYPE_JSON));
        Call call = Services.OK_HTTP_CLIENT_LOGGING.newCall(requestBuilder.build());
        final SettableCallFuture settableInputStreamFuture = SettableCallFuture.create(call);
        call.enqueue(new Callback(){

            public void onFailure(@Nonnull Call call, @Nonnull IOException e) {
                settableInputStreamFuture.setException(e);
            }

            public void onResponse(@Nonnull Call call, @Nonnull Response response) {
                int code = response.code();
                if (code == 404) {
                    settableInputStreamFuture.setException(new EndpointNotFoundException(String.format("API URL(%s) not found", HttpJmapApiClient.this.apiUrl)));
                    return;
                }
                if (code == 401) {
                    List challenges = HttpHeaders.parseChallenges((Headers)response.headers(), (String)"WWW-Authenticate");
                    settableInputStreamFuture.setException(new UnauthorizedException(String.format("API URL(%s) was unauthorized", HttpJmapApiClient.this.apiUrl), challenges));
                    return;
                }
                ResponseBody body = response.body();
                if (body == null) {
                    settableInputStreamFuture.setException(new IllegalStateException("response body was empty"));
                    return;
                }
                settableInputStreamFuture.set(body.byteStream());
            }
        });
        return settableInputStreamFuture;
    }

    @Override
    public boolean isValidFor(Session session) {
        return this.apiUrl.equals((Object)session.getApiUrl());
    }
}

