/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.api;

import okhttp3.HttpUrl;
import rs.ltt.jmap.client.api.HttpJmapApiClient;
import rs.ltt.jmap.client.api.JmapApiClient;
import rs.ltt.jmap.client.api.SessionStateListener;
import rs.ltt.jmap.client.api.WebSocketJmapApiClient;
import rs.ltt.jmap.client.event.WebSocketPushService;
import rs.ltt.jmap.client.http.HttpAuthentication;
import rs.ltt.jmap.client.session.Session;
import rs.ltt.jmap.client.util.WebSocketUtil;
import rs.ltt.jmap.common.entity.capability.WebSocketCapability;

public class JmapApiClientFactory {
    private final HttpAuthentication httpAuthentication;
    private final SessionStateListener sessionStateListener;

    public JmapApiClientFactory(HttpAuthentication httpAuthentication, SessionStateListener sessionStateListener) {
        this.httpAuthentication = httpAuthentication;
        this.sessionStateListener = sessionStateListener;
    }

    public JmapApiClient getJmapApiClient(Session session, boolean useWebSocket) {
        WebSocketCapability webSocketCapability = session.getCapability(WebSocketCapability.class);
        if (JmapApiClientFactory.validWebSocketCapability(webSocketCapability) && useWebSocket) {
            HttpUrl url = WebSocketUtil.normalizeUrl(session.getBase(), webSocketCapability.getUrl());
            if (Boolean.TRUE.equals(webSocketCapability.getSupportsPush())) {
                return new WebSocketPushService(url, this.httpAuthentication, this.sessionStateListener);
            }
            return new WebSocketJmapApiClient(url, this.httpAuthentication, this.sessionStateListener);
        }
        return new HttpJmapApiClient(session.getApiUrl(), this.httpAuthentication, this.sessionStateListener);
    }

    private static boolean validWebSocketCapability(WebSocketCapability capability) {
        return capability != null && capability.getUrl() != null;
    }
}

