/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.api;

import rs.ltt.jmap.client.api.JmapApiException;
import rs.ltt.jmap.common.method.MethodCall;
import rs.ltt.jmap.common.method.MethodErrorResponse;
import rs.ltt.jmap.common.method.MethodResponse;
import rs.ltt.jmap.common.method.error.InvalidArgumentsMethodErrorResponse;
import rs.ltt.jmap.common.util.Mapper;

public class MethodErrorResponseException
extends JmapApiException {
    private final MethodErrorResponse methodErrorResponse;
    private final MethodResponse[] additional;
    private final MethodCall methodCall;

    MethodErrorResponseException(MethodErrorResponse methodErrorResponse, MethodResponse[] additional, MethodCall methodCall) {
        super(MethodErrorResponseException.message(methodErrorResponse, additional, methodCall));
        this.methodErrorResponse = methodErrorResponse;
        this.additional = additional;
        this.methodCall = methodCall;
    }

    private static String message(MethodErrorResponse methodErrorResponse, MethodResponse[] additional, MethodCall methodCall) {
        String description;
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(methodErrorResponse.getType());
        if (additional != null && additional.length > 0) {
            messageBuilder.append(" + ");
            messageBuilder.append(additional.length);
        }
        messageBuilder.append(" in response to ");
        messageBuilder.append((String)Mapper.METHOD_CALLS.inverse().get(methodCall.getClass()));
        if (methodErrorResponse instanceof InvalidArgumentsMethodErrorResponse && (description = ((InvalidArgumentsMethodErrorResponse)methodErrorResponse).getDescription()) != null) {
            messageBuilder.append(" (");
            messageBuilder.append(description);
            messageBuilder.append(')');
        }
        return messageBuilder.toString();
    }

    public static boolean matches(Throwable throwable, Class<? extends MethodErrorResponse> methodError) {
        if (throwable instanceof MethodErrorResponseException) {
            MethodErrorResponseException methodErrorResponseException = (MethodErrorResponseException)throwable;
            return methodError.isInstance(methodErrorResponseException.getMethodErrorResponse());
        }
        return false;
    }

    public MethodErrorResponse getMethodErrorResponse() {
        return this.methodErrorResponse;
    }

    public MethodResponse[] getAdditional() {
        return this.additional == null ? new MethodResponse[]{} : this.additional;
    }

    public MethodCall getMethodCall() {
        return this.methodCall;
    }
}

