/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.blob;

import java.io.InputStream;
import okhttp3.Call;
import rs.ltt.jmap.client.blob.Progress;

public final class Download {
    private final Call call;
    private final boolean resumed;
    private final long contentLength;
    private final InputStream inputStream;

    public Download(Call call, boolean resumed, long contentLength, InputStream inputStream) {
        this.call = call;
        this.resumed = resumed;
        this.contentLength = contentLength;
        this.inputStream = inputStream;
    }

    public int progress(long done) {
        if (this.indeterminate()) {
            return 0;
        }
        return Progress.progress(done, this.contentLength);
    }

    public boolean indeterminate() {
        return this.contentLength == 0L;
    }

    public Call getCall() {
        return this.call;
    }

    public boolean isResumed() {
        return this.resumed;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void cancel() {
        this.call.cancel();
    }
}

