/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.blob;

import com.google.common.net.MediaType;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import rs.ltt.jmap.client.blob.Uploadable;

public class FileUpload
implements Uploadable,
Closeable {
    private final InputStream inputStream;
    private final long contentLength;
    private final MediaType mediaType;

    private FileUpload(Path path) throws IOException {
        this.inputStream = Files.newInputStream(path, new OpenOption[0]);
        this.contentLength = Files.size(path);
        this.mediaType = MediaType.parse((String)Files.probeContentType(path));
    }

    public static FileUpload of(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return new FileUpload(path);
        }
        throw new IOException(String.format("%s is not a regular file", path));
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

