/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.blob;

import com.google.common.net.MediaType;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import rs.ltt.jmap.client.blob.Uploadable;

public class LegacyFileUpload
implements Uploadable,
Closeable {
    private final FileInputStream inputStream;
    private final long contentLength;
    private final MediaType mediaType;

    private LegacyFileUpload(File file, MediaType mediaType) throws FileNotFoundException {
        this.inputStream = new FileInputStream(file);
        this.contentLength = file.length();
        this.mediaType = mediaType;
    }

    public static LegacyFileUpload of(File file, MediaType mediaType) throws IOException {
        if (file.isFile()) {
            return new LegacyFileUpload(file, mediaType);
        }
        throw new IOException(String.format("%s is not a regular file", file.getAbsoluteFile()));
    }

    @Override
    public FileInputStream getInputStream() {
        if (this.inputStream.closed) {
            throw new IllegalStateException("FileInputStream has already been closed. Are you using a network interceptor/logger?");
        }
        return this.inputStream;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private static class FileInputStream
    extends java.io.FileInputStream {
        private boolean closed = false;

        public FileInputStream(@NotNull File file) throws FileNotFoundException {
            super(file);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }
    }
}

