/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.blob;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import rs.ltt.jmap.client.blob.Uploadable;

public class OutputStreamUpload
implements Uploadable {
    private final MediaType mediaType;
    private final long contentLength;
    private final PipedInputStream inputStream;

    private OutputStreamUpload(MediaType mediaType, long contentLength) {
        this.mediaType = mediaType;
        this.contentLength = contentLength;
        this.inputStream = new PipedInputStream();
    }

    public static OutputStreamUpload of(MediaType mediaType) {
        return new OutputStreamUpload(mediaType, -1L);
    }

    public static OutputStreamUpload of(MediaType mediaType, long contentLength) {
        return new OutputStreamUpload(mediaType, contentLength);
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStream.closed) {
            throw new IllegalStateException("PipedInputStream has already been closed. Are you using a network interceptor/logger?");
        }
        return this.inputStream;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    public PipedOutputStream getOutputStream() throws IOException {
        return new PipedOutputStream(this.inputStream);
    }

    private static class PipedInputStream
    extends java.io.PipedInputStream {
        private boolean closed = false;

        private PipedInputStream() {
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }
    }
}

