/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.blob;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rs.ltt.jmap.client.blob.Progress;
import rs.ltt.jmap.client.blob.Uploadable;

public class RequestBodies {
    private static final int BLOCK_SIZE = 8196;

    public static RequestBody of(final Uploadable uploadable, final Progress progress) {
        return new RequestBody(){

            public long contentLength() {
                return uploadable.getContentLength();
            }

            @Nullable
            public okhttp3.MediaType contentType() {
                return RequestBodies.convert(uploadable.getMediaType());
            }

            public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                long done = 0L;
                try (Source source = Okio.source((InputStream)uploadable.getInputStream());){
                    long read;
                    while ((read = source.read(bufferedSink.getBuffer(), 8196L)) != -1L) {
                        done += read;
                        if (progress == null) continue;
                        bufferedSink.flush();
                        progress.onProgress(Progress.progress(done, uploadable.getContentLength()));
                    }
                }
                bufferedSink.flush();
            }
        };
    }

    private static okhttp3.MediaType convert(MediaType mediaType) {
        return okhttp3.MediaType.get((String)String.format("%s/%s", mediaType.type(), mediaType.subtype()));
    }
}

