/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.event;

import com.google.common.base.Strings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.ltt.jmap.client.Services;
import rs.ltt.jmap.client.event.CloseAfter;
import rs.ltt.jmap.client.event.OnConnectionStateChangeListener;
import rs.ltt.jmap.client.event.OnStateChangeListener;
import rs.ltt.jmap.client.event.OnStateChangeListenerManager;
import rs.ltt.jmap.client.event.PushService;
import rs.ltt.jmap.client.event.ReconnectionStrategy;
import rs.ltt.jmap.client.event.State;
import rs.ltt.jmap.client.http.HttpAuthentication;
import rs.ltt.jmap.client.session.Session;
import rs.ltt.jmap.common.entity.StateChange;

public class EventSourcePushService
implements PushService,
OnStateChangeListenerManager.Callback {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventSourcePushService.class);
    private final Session session;
    private final HttpAuthentication authentication;
    private final OnStateChangeListenerManager onStateChangeListenerManager = new OnStateChangeListenerManager(this);
    private final List<OnConnectionStateChangeListener> onConnectionStateListeners = new ArrayList<OnConnectionStateChangeListener>();
    private EventSource currentEventSource;
    private Duration pingInterval = Duration.ofSeconds(30L);
    private ReconnectionStrategy reconnectionStrategy = ReconnectionStrategy.truncatedBinaryExponentialBackoffStrategy(60, 4);
    private int attempt = 0;
    private State state = State.CLOSED;
    private ScheduledFuture<?> reconnectionFuture;

    public EventSourcePushService(Session session, HttpAuthentication authentication) {
        this.session = session;
        this.authentication = authentication;
    }

    private void disconnect(State state) {
        EventSource currentEventSource = this.currentEventSource;
        if (currentEventSource != null) {
            currentEventSource.cancel();
        }
        this.currentEventSource = null;
        this.transitionTo(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionTo(State state) {
        LOGGER.info("transition to {}", (Object)state);
        this.state = state;
        List<OnConnectionStateChangeListener> list = this.onConnectionStateListeners;
        synchronized (list) {
            for (OnConnectionStateChangeListener listener : this.onConnectionStateListeners) {
                listener.onConnectionStateChange(state);
            }
        }
        if (state.needsReconnect() && this.onStateChangeListenerManager.isPushNotificationsEnabled()) {
            this.scheduleReconnect();
        }
    }

    private void scheduleReconnect() {
        int attempt = this.attempt;
        Duration reconnectIn = this.reconnectionStrategy.getNextReconnectionAttempt(attempt);
        LOGGER.info("schedule reconnect in {} for {} time ", (Object)reconnectIn, (Object)(attempt + 1));
        this.reconnectionFuture = Services.SCHEDULED_EXECUTOR_SERVICE.schedule(this::connect, reconnectIn.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void cancelReconnectionFuture() {
        ScheduledFuture<?> future = this.reconnectionFuture;
        if (future != null && !future.isDone()) {
            future.cancel(false);
        }
    }

    private void connect() {
        HttpUrl eventSourceUrl;
        if (!this.state.needsReconnect()) {
            return;
        }
        ++this.attempt;
        this.cancelReconnectionFuture();
        this.transitionTo(State.CONNECTING);
        try {
            eventSourceUrl = this.session.getEventSourceUrl(Collections.emptyList(), CloseAfter.NO, this.pingInterval.getSeconds());
        }
        catch (Exception e) {
            LOGGER.warn("Unable to connect to EventSource URL");
            this.disconnect(State.FAILED);
            return;
        }
        this.connectEventSource(eventSourceUrl);
    }

    private void connectEventSource(HttpUrl eventSourceUrl) {
        EventSource.Factory factory = EventSources.createFactory((OkHttpClient)Services.OK_HTTP_CLIENT.newBuilder().readTimeout(this.pingInterval.plus(PING_INTERVAL_TOLERANCE)).retryOnConnectionFailure(true).build());
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(eventSourceUrl);
        this.authentication.authenticate(requestBuilder);
        requestBuilder.addHeader("Accept-Encoding", "identity");
        Request request = requestBuilder.build();
        LOGGER.info("Using event source url {}", (Object)eventSourceUrl);
        this.setCurrentEventSource(factory.newEventSource(request, (EventSourceListener)new EventSourceProcessor()));
    }

    private void setCurrentEventSource(EventSource eventSource) {
        if (this.currentEventSource != null) {
            throw new IllegalStateException("Unable to set current EventSource. One already exists");
        }
        this.currentEventSource = eventSource;
    }

    @Override
    public void setPingInterval(Duration pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void setReconnectionStrategy(ReconnectionStrategy reconnectionStrategy) {
        this.reconnectionStrategy = reconnectionStrategy;
    }

    private void onStateEvent(String id, String state) {
        StateChange stateChange = (StateChange)Services.GSON.fromJson(state, StateChange.class);
        this.onStateChangeListenerManager.onStateChange(stateChange);
    }

    private void onPingEvent() {
        LOGGER.info("ping event received");
    }

    @Override
    public void addOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.onStateChangeListenerManager.addOnStateChangeListener(onStateChangeListener);
    }

    @Override
    public void removeOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.onStateChangeListenerManager.removeOnStateChangeListener(onStateChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnConnectionStateListener(OnConnectionStateChangeListener onConnectionStateListener) {
        List<OnConnectionStateChangeListener> list = this.onConnectionStateListeners;
        synchronized (list) {
            this.onConnectionStateListeners.add(onConnectionStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnConnectionStateListener(OnConnectionStateChangeListener onConnectionStateListener) {
        List<OnConnectionStateChangeListener> list = this.onConnectionStateListeners;
        synchronized (list) {
            this.onConnectionStateListeners.remove(onConnectionStateListener);
        }
    }

    @Override
    public State getConnectionState() {
        return this.state;
    }

    @Override
    public void disable() {
        this.disconnect(State.CLOSED);
        this.cancelReconnectionFuture();
    }

    @Override
    public void enable() {
        this.connect();
    }

    private class EventSourceProcessor
    extends EventSourceListener {
        private EventSourceProcessor() {
        }

        public void onClosed(@NotNull EventSource eventSource) {
            super.onClosed(eventSource);
            EventSourcePushService.this.disconnect(State.CLOSED);
        }

        public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
            super.onEvent(eventSource, id, type, data);
            switch (Strings.nullToEmpty((String)type)) {
                case "state": {
                    EventSourcePushService.this.onStateEvent(id, data);
                    break;
                }
                case "ping": {
                    EventSourcePushService.this.onPingEvent();
                    break;
                }
            }
        }

        public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
            super.onFailure(eventSource, t, response);
            if (EventSourcePushService.this.onStateChangeListenerManager.isPushNotificationsEnabled()) {
                if (t != null) {
                    LOGGER.warn("Unable to connect to EventSource URL", t);
                } else if (response != null) {
                    LOGGER.warn("Unable to connect to EventSource URL. Status code was {}", (Object)response.code());
                } else {
                    LOGGER.warn("Unable to connect to EventSource URL");
                }
                EventSourcePushService.this.disconnect(State.FAILED);
            }
        }

        public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
            super.onOpen(eventSource, response);
            EventSourcePushService.this.attempt = 0;
            EventSourcePushService.this.transitionTo(State.CONNECTED);
        }
    }

    private static final class Type {
        public static final String STATE = "state";
        public static final String PING = "ping";

        private Type() {
        }
    }
}

